package com.elitesland.tw.tw5.api.prd.purchase.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.time.LocalDate;
import java.math.BigDecimal;

/**
 * 预付款收据管理
 *
 * @author wangly
 * @date 2024-05-27
 */
@Getter
@Setter
public class BillVerDetailPayload extends TwCommonPayload  implements Serializable {
    /** 付款申请单ID */
    @ApiModelProperty("付款申请单ID")
    private Long paymentApplyId;
    /** 票据号 */
    @ApiModelProperty("票据号")
    private String billNo;
    /** 本次核销金额 */
    @ApiModelProperty("本次核销金额")
    private BigDecimal theAmt;
    /** 票据金额 */
    @ApiModelProperty("票据金额")
    private BigDecimal invoiceAmt;
    /** 已核销金额 */
    @ApiModelProperty("已核销金额")
    private BigDecimal writtenOffAmt;
    /** 税率 */
    @ApiModelProperty("税率")
    private String rate;
    /** 票据日期 */
    @ApiModelProperty("票据日期")
    private LocalDate invoiceDate;
    /** 关联采购明细Id */
    @ApiModelProperty("关联采购明细Id")
    private Long purConOrAgreementDetailId;
    /** 关联采购明细Id */
    @ApiModelProperty("关联采购明细Id")
    private Long purConDetailId;
    /** 票据附件 */
    @ApiModelProperty("票据附件")
    private String fileCode;
    /** jde票据公司 */
    @ApiModelProperty("jde票据公司")
    private String jdecompany;
    /** jde单据号 */
    @ApiModelProperty("jde单据号")
    private String jdedocumentno;
    /** jde单据类型 */
    @ApiModelProperty("jde单据类型")
    private String jdedocumenttype;
    /** jde付款项 */
    @ApiModelProperty("jde付款项")
    private String jdepaymentitem;
    /** jde发票凭证失败原因 */
    @ApiModelProperty("jde发票凭证失败原因")
    private String jdeinvoicefailreason;
    /** 预留字段1 */
    @ApiModelProperty("预留字段1")
    private String ext1;
    /** 预留字段2 */
    @ApiModelProperty("预留字段2")
    private String ext2;
    /** 预留字段3 */
    @ApiModelProperty("预留字段3")
    private String ext3;
    /** 预留字段4 */
    @ApiModelProperty("预留字段4")
    private String ext4;
    /** 预留字段5 */
    @ApiModelProperty("预留字段5")
    private String ext5;
    /** 预留字段6 */
    @ApiModelProperty("预留字段6")
    private String ext6;
    /** 预留字段7 */
    @ApiModelProperty("预留字段7")
    private String ext7;
    /** 预留字段8 */
    @ApiModelProperty("预留字段8")
    private String ext8;
    /**
     * 发票凭证
     */
    @ApiModelProperty("发票凭证")
    private String invoiceVoucher;
}
