package com.elitesland.tw.tw5.api.prd.purchase.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.time.LocalDate;
import java.math.BigDecimal;

/**
 * 旧采购合同
 *
 * @author likunpeng
 * @date 2024-01-03
 */
@Getter
@Setter
public class PurchaseContractPayload extends TwCommonPayload  implements Serializable {
    /** 合同状态 */
    @ApiModelProperty("合同状态")
    private String contractStatus;
    /** 主合同id */
    @ApiModelProperty("主合同id")
    private Long mainContractId;
    /** 子合同id */
    @ApiModelProperty("子合同id")
    private Long subContractId;
    /** 供应商id */
    @ApiModelProperty("供应商id")
    private Long supplierId;
    /** 供应商bu_id */
    @ApiModelProperty("供应商bu_id")
    private Long supplierBuId;
    /** 签约日期 */
    @ApiModelProperty("签约日期")
    private LocalDate signDate;
    /** 平台合同类型 */
    @ApiModelProperty("平台合同类型")
    private String platType;
    /** 采购类型 */
    @ApiModelProperty("采购类型")
    private String purchaseType;
    /** 采购大类 */
    @ApiModelProperty("采购大类")
    private String purchaseType1;
    /** 采购小类 */
    @ApiModelProperty("采购小类")
    private String purchaseType2;
    /** 采购产品 */
    @ApiModelProperty("采购产品")
    private String productName;
    /** 采购内容简述 */
    @ApiModelProperty("采购内容简述")
    private String briefDesc;
    /** 合同金额 */
    @ApiModelProperty("合同金额")
    private BigDecimal amt;
    /** 税率 */
    @ApiModelProperty("税率")
    private Integer taxRate;
    /** 采购主体bu_id */
    @ApiModelProperty("采购主体bu_id")
    private Long purchaseBuId;
    /** 签单bu_id */
    @ApiModelProperty("签单bu_id")
    private Long signBuId;
    /** 销售人员资源id */
    @ApiModelProperty("销售人员资源id")
    private Long salesmanResId;
    /** 交付bu_id */
    @ApiModelProperty("交付bu_id")
    private Long deliBuId;
    /** 交付资源id */
    @ApiModelProperty("交付资源id")
    private Long deliResId;
    /** 激活日期 */
    @ApiModelProperty("激活日期")
    private LocalDate activateDate;
    /** 关闭日期 */
    @ApiModelProperty("关闭日期")
    private LocalDate closeDate;
    /** 关闭原因 */
    @ApiModelProperty("关闭原因")
    private String closeReason;
    /** 币种 */
    @ApiModelProperty("币种")
    private String currCode;
    /** 是否第三方外包（是/否） */
    @ApiModelProperty("是否第三方外包（是/否）")
    private Integer thirdPartFlag;
    /** 采购负责人 */
    @ApiModelProperty("采购负责人")
    private Long purchaseInchargeResId;
    /** 特殊码 */
    @ApiModelProperty("特殊码")
    private String specCode;
    /** 服务类型（用于区分采购类型和费用参与收益归属问题） */
    @ApiModelProperty("服务类型（用于区分采购类型和费用参与收益归属问题）")
    private String serviceType;
    /** 采购合同编号 */
    @ApiModelProperty("采购合同编号")
    private String contractNo;
    /** 采购合同名称 */
    @ApiModelProperty("采购合同名称")
    private String contractName;
    /** 供应商法人地址簿号 */
    @ApiModelProperty("供应商法人地址簿号")
    private Long supplierLegalBookId;
    /** 采购法人地址簿号 */
    @ApiModelProperty("采购法人地址簿号")
    private Long purchaseLegalBookId;
}
