package com.elitesland.tw.tw5.api.prd.purchase.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 人力资源结算费率
 *
 * @author lemon
 * @date 2023-11-02
 */
@Getter
@Setter
public class ResSetRatePayload extends TwCommonPayload implements Serializable {
    /** 采购协议单据ID */
    @ApiModelProperty("采购协议单据ID")
    private Long documentId;
    /** 采购协议单据编号 */
    @ApiModelProperty("采购协议单据编号")
    private String documentNo;
    /** 服务费率 */
    @ApiModelProperty("服务费率")
    private BigDecimal serviceRate;
    /** 开始金额 */
    @ApiModelProperty("开始金额")
    private BigDecimal startAtm;
    /** 结束金额 */
    @ApiModelProperty("结束金额")
    private BigDecimal endAtm;
}
