package com.elitesland.tw.tw5.api.prd.purchase.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 逾期付款查询
 *
 * @author likunpeng
 * @date 2023-11-24
 */
@Getter
@Setter
public class LatePaymentPlanQuery extends TwQueryParam implements Serializable {
    /** 采购合同编号/名称 */
    @ApiModelProperty("采购合同编号/名称")
    private String purchaseConNoOrName;

    /** 供应商BookId */
    @ApiModelProperty("供应商BookId")
    private Long supplierBookId;

    /** 采购负责人 */
    @ApiModelProperty("采购负责人")
    private Long purchaseInchargeResId;

    /** 预计付款日期开始 */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("预计付款日期开始")
    private LocalDate estimatedPaymentDateStart;

    /** 预计付款日期结束 */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("预计付款日期结束")
    private LocalDate estimatedPaymentDateEnd;

    /** 是否逾期（逾期标识）*/
    @ApiModelProperty("是否逾期（逾期标识）")
    private Boolean lateFlag = false;
}
