package com.elitesland.tw.tw5.api.prd.purchase.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 付款申请单
 *
 * @author likunpeng
 * @date 2023-11-07
 */
@Getter
@Setter
public class PurchasePaymentQuery extends TwQueryParam implements Serializable{
    /** 付款申请单名称/编号 模糊 */
    @ApiModelProperty("付款申请单名称/编号")
    private String paymentNameOrNo;
    /** 付款申请单类型 精确 */
    @ApiModelProperty("付款申请单类型")
    private String paymentApplicationType;
    /** 付款公司地址簿Id 精确*/
    @ApiModelProperty("付款公司地址簿Id")
    private Long payCompanyBookId;
    /** 供应商 精确 */
    @ApiModelProperty("供应商")
    private Long supplierLegalBookId;
    /** 付款申请单状态 精确 */
    @ApiModelProperty("付款申请单状态")
    private String state;
    /** 付款申请单状态 区间 */
    @ApiModelProperty("付款申请单状态 区间")
    private List<String> notInStateList;
    /** 验收方式 精确 */
    @ApiModelProperty("验收方式")
    private String acceptanceType;
    /** 关联销售合同 精确 */
    @ApiModelProperty("关联销售合同")
    private String relatedSalesContract;
    /** 关联项目号 精确 */
    @ApiModelProperty("关联项目号")
    private String relatedProjectNo;
    /** ids  */
    @ApiModelProperty("ids")
    private List<Long> ids;

    @ApiModelProperty("采购合同编号集合 精确")
    private List<String> purchaseContractNoList;


    @ApiModelProperty("采购合同编号集合 精确")
    private List<String> prePaymentNoList;
}
