package com.elitesland.tw.tw5.api.prd.purchase.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PaymentSlipPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PaymentSlipQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PaymentSlipVO;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 付款单记录
 *
 * @author likunpeng
 * @date 2023-11-23
 */
public interface PaymentSlipService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PaymentSlipVO}>
     */
    PagingVO<PaymentSlipVO> queryPaging(PaymentSlipQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PaymentSlipVO}>
     */
    PagingVO<PaymentSlipVO> queryAccountPaging(PaymentSlipQuery query);

    /**
     * 付款批准列表分组查询
     *
     * @param query 条件参数
     * @return {@link List}<{@link PaymentSlipVO}>
     */
    PagingVO<PaymentSlipVO> paymentApproveGroupPaging(PaymentSlipQuery query);
    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PaymentSlipVO}>
     */
    List<PaymentSlipVO> queryListDynamic(PaymentSlipQuery query);

    /**
     * 通过id集合查询
     *
     * @param idList id集合
     * @return {@link List}<{@link PaymentSlipVO}>
     */
    List<PaymentSlipVO> queryListByIds(List<Long> idList);
    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PaymentSlipVO}
     */
    PaymentSlipVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PaymentSlipVO}
     */
    PaymentSlipVO insert(PaymentSlipPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PaymentSlipVO}
     */
    PaymentSlipVO update(PaymentSlipPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PaymentSlipPayload payload);

    /**
     * 银企直连回调更新
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateBankCallBack(PaymentSlipPayload payload);
    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 批量新增付款申请单记录
     * @param paymentSlipPayloads 要新增的付款申请单记录
     */
    void insertAll(List<PaymentSlipPayload> paymentSlipPayloads);

    /**
     * 通过付款申请单id删除付款申请单记录
     * @param paymentApplyId 付款申请单id
     */
    void deleteByPaymentApplyId(Long paymentApplyId);

    /**
     * 根据付款申请单ID查询列表
     *
     * @param paymentApplyId 付款申请单ID
     * @return {@link List}<{@link PaymentSlipVO}>
     */
    List<PaymentSlipVO> queryListByPaymentApplyId(Long paymentApplyId);

    /**
     * 根据申请单Id修改付款申请单记录状态
     *
     * @param paymentApplyId 申请单Id
     * @param state 状态
     */
    void updateStatusByPaymentApplyId(Long paymentApplyId, String state);
    /**
     * 确认线下支付
     *
     * @param payloadList 单据集合
     */
    void confirmOfflinePayment(List<PaymentSlipPayload> payloadList);
    /**
     * 处理付款记录是否需要关闭合同
     *
     * @param idList 付款记录id集合
     *
     */
    void dealPaymentData(List<Long> idList);
    /**
     * 提交网银支付
     *
     * @param paymentSlipPayloadList 单据list
     */
    void commitOnlinePayment(List<PaymentSlipPayload> paymentSlipPayloadList);
    /**
     * 生成流水号
     *
     */
    void createPaySerialNum(List<PaymentSlipPayload> payloadList);

    /**
     * 查询流水号
     *
     */
    List<String> queryPaySerialNum();
    /**
     * 根据付款单主键Id修改付款记录的网银用途
     *
     * @param id 主键
     * @param payPurpose 网银/支付用途
     * @param paymentApplyNo 付款申请单编号
     *
     */
    void updatePayPurpose(Long id, String payPurpose,String paymentApplyNo);
    /**
     * 根据付款单主键Id修改付款记录的网银用途
     *
     * @param id 主键
     * @param receivingBank 收款银行
     * @param paymentApplyNo 付款申请单编号
     * @param receivingAccount 付款账号id
     */
    void updateReceiveAccount(Long id, String receivingBank,String receivingAccount,String paymentApplyNo);
    /**
     * 通过驳回
     *
     * @param paymentSlipPayloadList 单据集合
     */
    void passOrReject(List<PaymentSlipPayload> paymentSlipPayloadList);
    /**
     * 付款单记录-提交
     *
     * @param paymentSlipPayloadList 单据集合
     */
    void paymentCommit(List<PaymentSlipPayload> paymentSlipPayloadList);

    /**
     * 付款单提交记录-查询收款账号信息
     *
     * @param id 主键
     */
    BookAccountVO queryReceiveAccountInfo(Long id);

    /**
     * 查询付款单记录是否有除了已付款外的其他状态
     * @param paymentApplyId 付款申请单Id
     * @return 是/否
     */
    Boolean isOtherStatusByPaymentApplyId(Long paymentApplyId);

    /**
     * 关闭采购合同
     * @param contractNo 采购合同编号
     */
    void closePaymentContract(String contractNo);

    /**
     * 查询付款单记录未支付的金额
     * @param paymentApplyIdSet 付款申请单Id
     * @return result
     */
    Map<Long, BigDecimal> findNoPayAmtByPaymentApplyIdIn(Set<Long> paymentApplyIdSet);
}
