package com.elitesland.tw.tw5.api.prd.purchase.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementDetailsPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementDetailsQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurConOrAgreementDetailsSimpleVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementDetailsVO;

import java.util.List;

/**
 * 采购协议明细
 *
 * @author Echo
 * @date 2023-06-08
 */
public interface PurchaseAgreementDetailsService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PurchaseAgreementDetailsVO}>
     */
    PagingVO<PurchaseAgreementDetailsVO> queryPaging(PurchaseAgreementDetailsQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PurchaseAgreementDetailsVO}>
     */
    List<PurchaseAgreementDetailsVO> queryListDynamic(PurchaseAgreementDetailsQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PurchaseAgreementDetailsVO}
     */
    PurchaseAgreementDetailsVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PurchaseAgreementDetailsVO}
     */
    PurchaseAgreementDetailsVO insert(PurchaseAgreementDetailsPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PurchaseAgreementDetailsVO}
     */
    PurchaseAgreementDetailsVO update(PurchaseAgreementDetailsPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PurchaseAgreementDetailsPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 删除协议明细
     * @param documentIdList 协议IdList
     */
    void deleteSoftByDocumentIdList(List<Long> documentIdList);

    /**
     * 根据采购协议Id查询采购明细
     * @param purAgreementId 采购协议ID
     * @return 采购明细
     */
    List<PurConOrAgreementDetailsSimpleVO> queryByPurAgreementId(Long purAgreementId);
}
