package com.elitesland.tw.tw5.api.prd.purchase.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;


/**
  * 旧采购合同
  *
  * @author likunpeng
  * @date 2024-01-03
  */
@Getter
@Setter
public class PurchaseContractVO extends BaseViewModel implements Serializable {
    /** 合同状态 */
    @ApiModelProperty("合同状态")
    private String contractStatus;
    @UdcName(udcName = "purchase:old_con:status", codePropName = "contractStatus")
    private String contractStatusDesc;
    /** 主合同id */
    @ApiModelProperty("主合同id")
    private Long mainContractId;
    /** 子合同id */
    @ApiModelProperty("子合同id")
    private Long subContractId;
    /** 关联子合同名称 */
    @ApiModelProperty("关联子合同名称")
    private String subContractName;
    /** 关联子合同编号 */
    @ApiModelProperty("关联子合同编号")
    private String subContractCode;
    /** 供应商id */
    @ApiModelProperty("供应商id")
    private Long supplierId;
    /** 供应商bu_id */
    @ApiModelProperty("供应商bu_id")
    private Long supplierBuId;
    @UdcName(udcName = "BU", codePropName = "supplierBuId")
    private String supplierBuDesc;
    /** 签约日期 */
    @ApiModelProperty("签约日期")
    private LocalDate signDate;
    /** 平台合同类型 */
    @ApiModelProperty("平台合同类型")
    private String platType;
    @UdcName(udcName = "salecon:plat_type", codePropName = "platType")
    private String platTypeDesc;
    /** 采购类型 */
    @ApiModelProperty("采购类型")
    private String purchaseType;
    @UdcName(udcName = "purchase:old_con:pur_type", codePropName = "purchaseType")
    private String purchaseTypeDesc;
    /** 采购大类 */
    @ApiModelProperty("采购大类")
    private String purchaseType1;
    @UdcName(udcName = "purchase:old_con:PURCHASE_TYPE1", codePropName = "purchaseType1")
    private String purchaseType1Desc;
    /** 采购小类 */
    @ApiModelProperty("采购小类")
    private String purchaseType2;
    @UdcName(udcName = "purchase:old_con:PURCHASE_TYPE2", codePropName = "purchaseType2")
    private String purchaseType2Desc;
    /** 采购产品 */
    @ApiModelProperty("采购产品")
    private String productName;
    /** 采购内容简述 */
    @ApiModelProperty("采购内容简述")
    private String briefDesc;
    /** 合同金额 */
    @ApiModelProperty("合同金额")
    private BigDecimal amt;
    /** 税率 */
    @ApiModelProperty("税率")
    private Integer taxRate;
    /** 采购主体bu_id */
    @ApiModelProperty("采购主体bu_id")
    private Long purchaseBuId;
    @UdcName(udcName = "BU", codePropName = "purchaseBuId")
    private String purchaseBuIdDesc;
    /** 签单bu_id */
    @ApiModelProperty("签单bu_id")
    private Long signBuId;
    @UdcName(udcName = "BU", codePropName = "signBuId")
    private String signBuIdDesc;
    /** 销售人员资源id */
    @ApiModelProperty("销售人员资源id")
    private Long salesmanResId;
    @UdcName(udcName = "USER", codePropName = "salesmanResId")
    private String salesmanResIdDesc;
    /** 交付bu_id */
    @ApiModelProperty("交付bu_id")
    private Long deliBuId;
    @UdcName(udcName = "BU", codePropName = "deliBuId")
    private String deliBuIdDesc;
    /** 交付资源id */
    @ApiModelProperty("交付资源id")
    private Long deliResId;
    @UdcName(udcName = "USER", codePropName = "deliResId")
    private String deliResIdDesc;
    /** 激活日期 */
    @ApiModelProperty("激活日期")
    private LocalDate activateDate;
    /** 关闭日期 */
    @ApiModelProperty("关闭日期")
    private LocalDate closeDate;
    /** 关闭原因 */
    @ApiModelProperty("关闭原因")
    private String closeReason;
    @UdcName(udcName = "purchase:old_con:close_reason", codePropName = "closeReason")
    private String closeReasonDesc;
    /** 币种 */
    @ApiModelProperty("币种")
    private String currCode;
    @UdcName(udcName = "SYSTEM_BASIC:CURRENCY", codePropName = "currCode")
    private String currCodeDesc;
    /** 是否第三方外包（是/否） */
    @ApiModelProperty("是否第三方外包（是/否）")
    private Integer thirdPartFlag;
    /** 采购负责人 */
    @ApiModelProperty("采购负责人")
    private Long purchaseInchargeResId;
    @UdcName(udcName = "USER", codePropName = "purchaseInchargeResId")
    private String purchaseInchargeResIdName;
    /** 特殊码 */
    @ApiModelProperty("特殊码")
    private String specCode;
    /** 服务类型（用于区分采购类型和费用参与收益归属问题） */
    @ApiModelProperty("服务类型（用于区分采购类型和费用参与收益归属问题）")
    private String serviceType;
    /** 采购合同编号 */
    @ApiModelProperty("采购合同编号")
    private String contractNo;
    /** 采购合同名称 */
    @ApiModelProperty("采购合同名称")
    private String contractName;
    /** 供应商法人地址簿号 */
    @ApiModelProperty("供应商法人地址簿号")
    private Long supplierLegalBookId;
    @UdcName(udcName = "BOOK", codePropName = "supplierLegalBookId")
    private String supplierLegalName;
    /** 采购法人地址簿号 */
    @ApiModelProperty("采购法人地址簿号")
    private Long purchaseLegalBookId;
    @UdcName(udcName = "BOOK", codePropName = "purchaseLegalBookId")
    private String purchaseLegalName;
    /** 审批状态 */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /** 审批状态DESC */
    @ApiModelProperty("审批状态Desc")
    @UdcName(udcName = "appr_status", codePropName = "apprStatus")
    private String apprStatusDesc;
    /** 付款计划 */
    @ApiModelProperty("付款计划")
    private List<PcontractPayplanVO> pcontractPayplanVOS;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    @UdcName(udcName = "USER", codePropName = "createUserId")
    private String createUserName;

}
