package com.elitesland.tw.tw5.api.prd.salecon.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConEpibolyCostConDVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 外包费用确认单
 *
 * @author likunpeng
 * @date 2023-04-17
 */
@Getter
@Setter
public class ConEpibolyCostConPayload extends TwCommonPayload  implements Serializable {
    /** 合同ID */
    @ApiModelProperty("合同ID")
    private Long contractId;
    /** 外包费用单号 */
    @ApiModelProperty("外包费用单号")
    private String epibolyCostNo;
    /** 申请人 */
    @ApiModelProperty("申请人")
    private Long applyUserId;
    /** 申请日期 */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /** 申请BU */
    @ApiModelProperty("申请BU")
    private Long applyBuId;
    private Long costConIdV4;
    /**外包费用确认明细 */
    @ApiModelProperty("外包费用确认明细")
    private List<ConEpibolyCostConDPayload> conEpibolyCostConDPayloads;
}
