package com.elitesland.tw.tw5.api.prd.salecon.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 业绩统计
 *
 * @author likunpeng
 * @date 2023-04-24
 */
@Getter
@Setter
public class ConAchieveQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 合同ID 精确 */
    @ApiModelProperty("合同ID")
    private Long contractId;
    /** 折算后有效销售额 精确 */
    @ApiModelProperty("折算后有效销售额")
    private BigDecimal obversionEffectiveAmt;
    /** 业绩统计状态 精确 */
    @ApiModelProperty("业绩统计状态")
    private String achieveStatus;
    /** 平台提成比例 */
    @ApiModelProperty("平台提成比例")
    private BigDecimal percentage;
}
