package com.elitesland.tw.tw5.api.prd.salecon.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 外包费用确认明细
 *
 * @author likunpeng
 * @date 2023-04-17
 */
@Getter
@Setter
public class ConEpibolyCostConDQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 外包费用确认单ID 精确
     */
    @ApiModelProperty("外包费用确认单ID")
    private Long epibolyCostConId;
    /**
     * 工作类型 精确
     */
    @ApiModelProperty("工作类型")
    private String workType;
    /**
     * 具体理由 模糊
     */
    @ApiModelProperty("具体理由")
    private String reason;
    /**
     * 伙伴类型 精确
     */
    @ApiModelProperty("伙伴类型")
    private String partnerType;
    /**
     * 合作方 精确
     */
    @ApiModelProperty("合作方")
    private String collaborator;
    /**
     * 基于 精确
     */
    @ApiModelProperty("基于")
    private String base;
    /**
     * 比例 精确
     */
    @ApiModelProperty("比例")
    private Integer proportion;
    /**
     * 金额 精确
     */
    @ApiModelProperty("金额")
    private BigDecimal amt;
    /**
     * 税费率 精确
     */
    @ApiModelProperty("税费率")
    private BigDecimal taxRate;
    /**
     * 税费 精确
     */
    @ApiModelProperty("税费")
    private BigDecimal taxCost;
    /**
     * 税费承担方 精确
     */
    @ApiModelProperty("税费承担方")
    private String taxPayer;
    /**
     * 净支付额 精确
     */
    @ApiModelProperty("净支付额")
    private BigDecimal netPay;
    /**
     * 具体支付方式 精确
     */
    @ApiModelProperty("具体支付方式")
    private String paymentMethod;
    /**
     * 线下合同&沟通签署状态 精确
     */
    @ApiModelProperty("线下合同&沟通签署状态")
    private String contractStatus;
    /**
     * 联系人姓名 精确
     */
    @ApiModelProperty("联系人姓名")
    private String liaisonName;
    /**
     * 联系电话 精确
     */
    @ApiModelProperty("联系电话")
    private String liaisonPhone;
    /**
     * 关联单据类型 精确
     */
    @ApiModelProperty("关联单据类型")
    private String docType;
    /**
     * 关联单据号 精确
     */
    @ApiModelProperty("关联单据号")
    private String documentNumber;
    /**
     * 父明细 精确
     */
    @ApiModelProperty("父明细")
    private Long parentId;

    /**
     * 外包费用单号
     */
    @ApiModelProperty("外包费用单号")
    @Query
    private String epibolyCostConCode;
    /**
     * 申请人
     */
    @ApiModelProperty("申请人Id")
    @Query
    private Long applyUserId;
    /**
     * 申请BU
     */
    @ApiModelProperty("申请人BU")
    @Query
    private Long applyBuId;
    /**
     * 申请日期范围
     */
    @ApiModelProperty("申请日期范围")
    @Query
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> applyDate;
    /**
     * 参考合同号
     */
    @ApiModelProperty("参考合同号")
    @Query
    private String referCode;
    /**
     * 客户Id
     */
    @ApiModelProperty("客户Id")
    @Query
    private Long custId;
    /**
     * 明细状态 精确
     */
    @ApiModelProperty("明细状态")
    @Query
    private String detailedStatus;
    /**
     * 当前登录人负责的签单bu
     */
    @ApiModelProperty("当前登录人负责的签单bu")
    @Query
    private List<Long> inchargeSignBus;
    /**
     * 组织id集合，用于列表权限
     */
    private List<Long> orgIdsByPermission;

    /**
     * 用户id集合，用于列表权限
     */
    private List<Long> userIdsByPermission;

    /**
     * 符合所有权限的
     */
    private Boolean authAll = false;

    @ApiModelProperty("明细ID集合")
    private List<Long> idList;

    /**
     * 查明细的标记 -> 如果为true直接取，不关父级是否为null
     */
    private Boolean queryDtlFlag = false;

}
