package com.elitesland.tw.tw5.api.prd.salecon.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * invdtl
 *
 * @author zoey
 * @date 2023-08-02
 */
@Getter
@Setter
public class ConInvBatchInvdtlQuery extends TwQueryParam implements Serializable {
    /**
     * 精确
     */
    @ApiModelProperty("")
    private Long id;

    private List<Long> ids;
    /**
     * 开票批次ID 精确
     */
    @ApiModelProperty("开票批次ID")
    private Long invbatchId;
    /**
     * 发票号 精确
     */
    @ApiModelProperty("发票号")
    private String invNo;
    /**
     * 不含税金额 精确
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 税额 精确
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 发票金额 精确
     */
    @ApiModelProperty("发票金额")
    private BigDecimal invAmt;
    /**
     * 发票状态 精确
     */
    @ApiModelProperty("发票状态")
    private String invStatus;
    /**
     * 快递单号 精确
     */
    @ApiModelProperty("快递单号")
    private String deliveryNo;
    /**
     * 快递日期 精确
     */
    @ApiModelProperty("快递日期")
    private LocalDate deliveryDate;
    /**
     * 发票来源（null:手工插入） 精确
     */
    @ApiModelProperty("发票来源（null:手工插入）")
    private String comeFrom;
    /**
     * 发票下载地址（null:手工插入无地址） 精确
     */
    @ApiModelProperty("发票下载地址（null:手工插入无地址）")
    private String downloadUrl;

    /**
     * 开票主体公司ID
     */
    @ApiModelProperty("开票主体公司ID")
    private Long invOuId;

    /**
     * 开票人
     */
    @ApiModelProperty("开票人")
    private Long invUserId;//开票人

    /**
     * 子合同号
     */
    @ApiModelProperty("子合同号")
    private String subContractNo;


    /**
     * 工作类型
     */
    @ApiModelProperty("工作类型")
    private String workType;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String custName;


    /**
     * JDE客户编号
     */
    @ApiModelProperty("JDE客户编号")
    private String customerNo;

    /**
     * 发票抬头
     */
    @ApiModelProperty("发票抬头")
    private String invTitle;

    /**
     * 实际开票日期 精确
     */
    @ApiModelProperty("实际开票日期")
    private List<LocalDate> actualInvDate;
}
