package com.elitesland.tw.tw5.api.prd.salecon.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 收款计划
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Getter
@Setter
public class ConReceivablePlanQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    @Query
    private Long id;

    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID列表")
    @Query
    private List<Long> ids;
    /**
     * 收款号 模糊
     */
    @ApiModelProperty("收款号")
    @Query(type = Query.Type.INNER_LIKE)
    private String receNo;
    /**
     * 收款阶段 精确
     */
    @ApiModelProperty("收款阶段")
    @Query
    private String receStage;
    /**
     * 当期收款金额 精确
     */
    @ApiModelProperty("当期收款金额")
    @Query
    private BigDecimal receAmt;
    /**
     * 当期收款比例 精确
     */
    @ApiModelProperty("当期收款比例")
    @Query
    private BigDecimal receRatio;
    /**
     * 收款状态 精确
     */
    @ApiModelProperty("收款状态")
    @Query
    private String receStatus;

    @ApiModelProperty("收款状态")
    @Query
    private List<String> receStatusList;
    /*预计开票日期 结束日期 */
    @ApiModelProperty("预计开票日期 结束日期")
    @Query
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate expectInvDateEnd;
    /**
     * 预计开票日期 精确
     */
    @ApiModelProperty("预计开票日期")
    @Query
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> expectInvDate;
    /**
     * 开票状态 精确
     */
    @ApiModelProperty("开票状态")
    @Query
    private String invStatus;

    @ApiModelProperty("开票状态")
    @Query
    private List<String> invStatusList;

    /**
     * 税率 精确
     */
    @ApiModelProperty("税率")
    @Query
    private BigDecimal taxRate;
    /**
     * 已开票金额 精确
     */
    @ApiModelProperty("已开票金额")
    @Query
    private BigDecimal alreadyInvAmt;
    /**
     * 未开票金额 精确
     */
    @ApiModelProperty("未开票金额")
    @Query
    private BigDecimal notInvAmt;
    /**
     * 已收款金额 精确
     */
    @ApiModelProperty("已收款金额")
    @Query
    private BigDecimal alreadyReceAmt;
    /**
     * 未收款金额 精确
     */
    @ApiModelProperty("未收款金额")
    @Query
    private BigDecimal notReceAmt;
    /**
     * 已确认金额
     */
    @ApiModelProperty("已确认金额")
    @Query
    private List<String> confirmedAmt;//已确认金额
    /** 已确认金额 */
    /**
     * 已确认金额 精确
     */
    @ApiModelProperty("已确认金额")
    @Query
    private List<String> distAmt;//已确认金额
    /**
     * 确认收入日期 精确
     */
    @ApiModelProperty("确认收入日期")
    @Query
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate confirmedAmtDate;
    /**
     * 子合同ID 精确
     */
    @ApiModelProperty("子合同ID")
    @Query
    private Long saleConId;

    /**
     * 子合同IDs 精确
     */
    @ApiModelProperty("子合同IDs")
    @Query
    private List<Long> saleConIds;
    /**
     * 客户ID 精确
     */
    @ApiModelProperty("客户ID")
    @Query
    private Long custId;
    /**
     * 子合同号 模糊
     */
    @ApiModelProperty("子合同号")
    @Query
    private String saleConCode;
    /**
     * 子合同名称 模糊
     */
    @ApiModelProperty("子合同名称")
    @Query
    private String saleConName;
    /**
     * 主合同名称 模糊
     */
    @ApiModelProperty("主合同名称")
    @Query
    private String parentName;
//    /**
//     * 主合同签约客户 模糊
//     */
//    @ApiModelProperty("主合同签约客户")
//    @Query
//    private Long ouId;

    /**
     * 主合同签约客户 模糊
     */
    @ApiModelProperty("主合同签约客户")
    @Query
    private Long ouBookId;
    /** 参考合同号 */
    /**
     * 参考合同号
     */
    @ApiModelProperty("参考合同号")
    @Query
    private String referCode;
    /**
     * 子合同状态
     */
    @ApiModelProperty("子合同状态")
    @Query
    private String saleConStatus;
    /**
     * 子合同状态
     */
    @ApiModelProperty("子合同状态")
    @Query
    private List<String> saleConStatusIn;
    /**
     * 交付BU_ID
     */
    @ApiModelProperty("交付BU_ID")
    @Query
    private Long deliBuId;
    /**
     * 交付BU负责人ID
     */
    @ApiModelProperty("交付BU负责人ID")
    @Query
    private Long deliUserId;
    /**
     * 销售人员用户ID
     */
    @ApiModelProperty("销售人员用户ID")
    @Query
    private Long saleManUserId;
    /**
     * PMO用户ID
     */
    @ApiModelProperty("PMO用户ID")
    @Query
    private Long pmoUserId;
    /**
     * 预计收款日期 范围
     */
    @ApiModelProperty("预计收款日期 范围")
    @Query
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> expectReceDate;
    @ApiModelProperty("预计收款日期 结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate expectRecvDateEnd;

    /**
     * 开票日期 范围
     */
    @ApiModelProperty("开票日期 范围")
    @Query
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> invDate;

    /**
     * 开票主体公司ID 精确
     */
    @ApiModelProperty("开票主体公司ID")
    private Long invOuId;
    /**
     * 实际收款日期 范围
     */
    @ApiModelProperty("实际收款日期 范围")
    @Query
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> actualRecvDate;

    /**
     * 开票批次ID[con_inv_batch]
     */
    private Long invBatchId;
    private List<Long> invBatchIds;

    /**
     * 模板：model 数据：data
     */
    @ApiModelProperty("预计收款日期 范围")
    private String downloadType;


    /**
     * 组织id集合，用于列表权限
     */
    private List<Long> orgIdsByPermission;

    /**
     * 用户id集合，用于列表权限
     */
    private List<Long> userIdsByPermission;

    /**
     * 是否需要权限判断
     */
    private Boolean isPermission = true;
    /**
     * 收款号
     */
    private List<String> receNos;

    private Long signBuId;

    /**
     * 已回收标志
     */
    private Integer recycleSettleFlag;


    /**
     * 自动收款/手动收款查询标志 自动和手动收款的时候
     * 自动收款传1  查询未开票 已开票 且 开票状态是已开票代收款 空
     * 手动收款传2  不查询已全额收款 且 开票状态是已开票代收款  收款中 空
     */
    private Integer receiveAccountFlag;
}
