package com.elitesland.tw.tw5.api.prd.salecon.service;

import com.elitesland.tw.tw5.api.prd.salecon.payload.ConAchievePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConAchieveQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConAchieveDVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConAchieveVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * 业绩统计
 *
 * @author likunpeng
 * @date 2023-04-24
 */
public interface ConAchieveService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConAchieveVO}>
     */
    PagingVO<ConAchieveVO> queryPaging(ConAchieveQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConAchieveVO}>
     */
    List<ConAchieveVO> queryListDynamic(ConAchieveQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ConAchieveVO}
     */
    ConAchieveVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ConAchieveVO}
     */
    ConAchieveVO insert(ConAchievePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ConAchieveVO}
     */
    ConAchieveVO update(ConAchievePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据合同ID查询业绩统计
     * @param contractId
     * @return ConAchieveVO
     */
    ConAchieveVO queryByContractId(Long contractId);

    /**
     * 保存业绩统计
     * @param payload
     * @return ConAchieveVO
     */
    ConAchieveVO saveAchieve(ConAchievePayload payload);

    /**
     * 同步业绩统计
     * @param param
     */
    @Deprecated
    void syncConAchieveTo4(String param);

    @Deprecated
    List<ConAchieveDVO> initSignAndDeli(Long contractId);

    List<ConAchieveDVO> initSignAndDeliDib(Long contractId, BigDecimal obversionEffectiveAmt);
}
