package com.elitesland.tw.tw5.api.prd.salecon.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingMonthPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvSettingMonthQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingMonthVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * ConInvSettingMonthController
 *
 * @author zoey
 * @date 2024-03-14
 */
public interface ConInvSettingMonthService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConInvSettingMonthVO}>
     */
    PagingVO<ConInvSettingMonthVO> queryPaging(ConInvSettingMonthQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConInvSettingMonthVO}>
     */
    List<ConInvSettingMonthVO> queryListDynamic(ConInvSettingMonthQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ConInvSettingMonthVO}
     */
    ConInvSettingMonthVO queryByKey(Long key);


    /**
     * 通过主表id查询
     *
     * @param invSettingId 通过主表id查询
     * @return {@link ConInvSettingMonthVO}
     */
    List<ConInvSettingMonthVO> queryByInvSetting(ConInvSettingVO vo);


    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ConInvSettingMonthVO}
     */
    ConInvSettingMonthVO insert(ConInvSettingMonthPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ConInvSettingMonthVO}
     */
    ConInvSettingMonthVO update(ConInvSettingMonthPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(ConInvSettingMonthPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
