package com.elitesland.tw.tw5.api.prd.salecon.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanConfirmPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanConfirmQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanConfirmVO;

import java.util.List;

/**
 * 收款计划确认单
 *
 * @author lemon
 * @date 2023-12-23
 */
public interface ConReceivablePlanConfirmService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConReceivablePlanConfirmVO}>
     */
    PagingVO<ConReceivablePlanConfirmVO> queryPaging(ConReceivablePlanConfirmQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConReceivablePlanConfirmVO}>
     */
    List<ConReceivablePlanConfirmVO> queryListDynamic(ConReceivablePlanConfirmQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ConReceivablePlanConfirmVO}
     */
    ConReceivablePlanConfirmVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ConReceivablePlanConfirmVO}
     */
    ConReceivablePlanConfirmVO insert(ConReceivablePlanConfirmPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ConReceivablePlanConfirmVO}
     */
    ConReceivablePlanConfirmVO update(ConReceivablePlanConfirmPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(ConReceivablePlanConfirmPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     *
     * @param signBuId
     * 4.0逻辑周一系统自动触发检查，有复合催款条件的；并创建工作流；
     * 需要催款的收款计划检索条件： 1，未开票的 收款记录：预计收款 <=当前日 + 提醒提前天数[系统配置]； 2，已开票、部分收款的收款记录：预计收款日期 <= 当前日； 3，此记录没有未完成的催款流程；
     * 每一条记录，均创建一个流程； 调整 2022 07 27 干系人：董海峰 何申夏 收款计划流程的自动触发调整，需要临时调整下。 1，调整为：仅需要对已开票未收款的收款计划触发流程。 暂时不对未开票的收款计划触发流程，触发逻辑的代码保留，仅目前不做触发。 2，合同里标注了“项目异常”字样的，都不做触发。
     * @return
     */
    int autoCreateFlow(Long signBuId);

}
