package com.elitesland.tw.tw5.api.prd.salecon.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.ObjectUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;


/**
 * 采购需求处理明细
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Getter
@Setter
@ExcelIgnoreUnannotated
public class ConPurchaseDemandDVO extends BaseViewModel implements Serializable {
    /**
     * 需求日期
     */
    @ApiModelProperty("需求日期")
    private LocalDate demandDate;
    @ExcelProperty(index = 11,value = "需求日期")
    private String demandDateStr;
    /**
     * 需求负责人
     */
    @ApiModelProperty("需求负责人ID")
    private Long demandDirectorUserId;
    @ExcelProperty(index = 7,value = "需求负责人")
    @UdcName(udcName = "USER", codePropName = "demandDirectorUserId")
    @ApiModelProperty("需求负责人姓名")
    private String demandDirectorUserName;
    /**
     * 建议供应商ID
     */
    @ApiModelProperty("建议供应商ID")
    private Long supplierId;
//    @UdcName(udcName = "USER", codePropName = "supplierId")
    @ApiModelProperty("建议供应商Name")
    private String supplierName;
    /**
     * 需求说明
     */
    @ApiModelProperty("需求说明")
    private String demandSaid;
    /**
     * 关联产品
     */
    @ApiModelProperty("关联产品")
    private Long productId;
    @ExcelProperty(index = 13,value = "关联产品")
    private String productName;

    /**
     * 采购大类
     */
    @ApiModelProperty("采购大类")
    private String productClass;
    @ExcelProperty(index = 14,value = "产品大类名称")
//    @UdcName(udcName = "con:purchase_type", codePropName = "productClass")
    private String productClassDesc;
    /**
     * 采购小类
     */
    @ApiModelProperty("采购小类")
    private String productSubClass;
    @ExcelProperty(index = 15,value = "产品小类名称")
    private String productSubClassDesc;
    /**
     * 数量
     */
    @ApiModelProperty("数量")
    @ExcelProperty(index = 16,value = "数量")
    private Integer demandNum;
    /**
     * 含税单价
     */
    @ApiModelProperty("含税单价")
    private BigDecimal taxPrice;
    /**
     * 货币
     */
    @ApiModelProperty("货币")
    private String symbol;
    @ExcelProperty(index = 12,value = "货币")
    @UdcName(udcName = "SYSTEM_BASIC:CURRENCY", codePropName = "symbol")
    private String symbolDesc;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ExcelProperty(index = 10,value = "税率")
    @UdcName(udcName = "prd:ab:tax_rate", codePropName = "taxRate")
    private String taxRateDesc;
    /**
     * 含税总额
     */
    @ApiModelProperty("含税总额")
    @ExcelProperty(index = 9,value = "含税总额")
    private BigDecimal taxAmt;
    /**
     * 不含税总额
     */
    @ApiModelProperty("不含税总额")
    private BigDecimal notTaxAmt;
    /**
     * 采购合同id
     */
    @ApiModelProperty("采购合同id")
    private Long purContractId;

    /**
     * 采购需求id
     */
    @ApiModelProperty("采购需求id")
    private Long purDemandId;
    /**
     * 销售合同id
     */
    @ApiModelProperty("销售合同id")
    private Long saleConId;
    /**
     * 销售合同名称
     */
    @ApiModelProperty("销售合同名称")
    @ExcelProperty(index = 2,value = "销售合同名称")
    private String saleConName;
    /**
     * 销售合同编号
     */
    @ApiModelProperty("销售合同编号")
    @ExcelProperty(index = 1,value = "销售合同编号")
    private String saleConCode;
    /**
     * 客户ID
     */
    @ApiModelProperty("客户ID")
    private Long custId;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @ExcelProperty(index = 3,value = "客户名称")
    private String custName;
    /**
     * 需求备注
     */
    @ApiModelProperty("需求备注")
    @ExcelProperty(index = 4,value = "需求备注")
    private String demandRem;
    /**
     * 采购合同编号
     */
    @ApiModelProperty("采购合同编号")
    @ExcelProperty(index = 5,value = "采购合同编号")
    private String purContractCode;
    /**
     * 需求状态
     */
    @ApiModelProperty("需求状态")
    private String demandStatus;
    @ExcelProperty(index = 6,value = "需求状态")
    @UdcName(udcName = "con:demandStatus", codePropName = "demandStatus")
    private String demandStatusDesc;
    /**
     * 需求编号
     */
    @ApiModelProperty("需求编号")
    @ExcelProperty(index = 0,value = "需求编号")
    private String demandCode;
    /**
     * 需求类别
     */
    @ApiModelProperty("需求类别")
    private String demandType;
    @ExcelProperty(index = 8,value = "需求类别")
    @UdcName(udcName = "salecon:demand_type", codePropName = "demandType")
    private String demandTypeDesc;
    /**
     * 参考合同号
     */
    @ApiModelProperty("参考合同号")
    private String referCode;
    /**
     * 关联合同ID
     */
    @ApiModelProperty("关联合同ID")
    private Long relatedContractId;
    /**
     * 关联合同状态
     */
    @ApiModelProperty("关联合同状态")
    private String relatedContractStatus;
    @ApiModelProperty("关联合同状态翻译")
    @UdcName(udcName = "salecon:status", codePropName = "relatedContractStatus")
    private String relatedContractStatusDesc;
    /**
     * 关联合同所关联项目Id
     */
    @ApiModelProperty("关联合同所关联项目Id")
    private Long projId;
    /**
     * 关联合同Code
     */
    @ApiModelProperty("关联合同Code")
//    @ExcelProperty(index = 3,value = "关联合同号")
    private String relatedContractCode;

    private Long productClassId;

    private Long productSubClassId;

    private Long demandDetailIdV4;

    public String getDemandDateStr() {
        return ObjectUtils.isEmpty(this.demandDate) ? null : this.demandDate.toString();
    }

}
