package com.elitesland.tw.tw5.api.prd.salecon.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

@Getter
@Setter
public class ConRecvplanChangeLogVO extends BaseViewModel implements Serializable {

    /**
     * 提交人用户id
     */
    private Long createUserId;
    /**
     * 提交人
     */
    @UdcName(udcName = "USER", codePropName = "createUserId")
    private String createUserName;
//    @ApiModelProperty("记录最后更新者ID")
//    private Long modifyUserId;
//    @UdcName(udcName = "USER", codePropName = "modifyUserId")
//    private String modifyUserName;
    /**
     * 收款计划ID
     */
    @ApiModelProperty("收款计划ID")
    private Long recvplanId;

    /**
     * 旧日期
     */
    @ApiModelProperty("旧日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate oldRecvOrInvDate;

    /**
     * 新日期
     */
    @ApiModelProperty("新日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate recvOrInvDate;

    /**
     * 类型，RECV-收款，INV-开票
     */
    @ApiModelProperty("类型，RECV-收款，INV-开票")
    private String type;

    /**
     * 原因
     */
    @ApiModelProperty("原因")
    private String reason;

    private Boolean flag1;

    private Boolean flag2;

    private Boolean flag3;

    /**
     * 变更人用户Id
     */
    private Long applyUserId;

    // 董海峰 2022年06月29日18:44:28  目的:财务的报表查询需求，能追溯到每次流程对应的变更历史。
    /**
     * 收款计划确认单Id   字段意义：通过收款计划确认单 关联到 唯一的一个变更记录
     */
    @ApiModelProperty("收款计划确认单Id")
    private Long rcvpConfirmId;

    /**
     * 变更前金额
     */
    @ApiModelProperty("变更前金额")
    private BigDecimal beforeAmt;
    /**
     * 变更后金额
     */
    @ApiModelProperty("变更后金额")
    private BigDecimal afterAmt;
}
