package com.elitesland.tw.tw5.api.prd.schedule.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;

/**
 * @author zoey
 * @Description:
 * @date 2022/4/19 - 14:36
 */
@Data
public class QyWxScheduleRepeatPayload{

    @ApiModelProperty("是否提醒")
    private Integer is_remind;

    @ApiModelProperty("提前发送提醒时间")
    private Integer remind_before_event_secs;

    @ApiModelProperty("是否重复")
    private Integer is_repeat;

    @ApiModelProperty("重复类型")
    private Integer repeat_type;

    @ApiModelProperty("重复结束时刻")
    private Long repeat_until;

    @ApiModelProperty("是否自定义重复")
    private Integer is_custom_repeat;

    @ApiModelProperty("重复间隔")
    private Integer repeat_interval;

    @ApiModelProperty("每周周几重复")
    private List<Integer> repeat_day_of_week;

    @ApiModelProperty("每月哪几天重复")
    private List<Integer> repeat_day_of_month;

    @ApiModelProperty("时区")
    private Integer timezone=8;

    /**
     * [{"start_time": 1571361000},{"start_time": 1571361000}]
     */
    @ApiModelProperty("重复排除日期列表")
    private List<Map<String,Long>> exclude_time_list;
}
