package com.elitesland.tw.tw5.api.prd.schedule.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;


@Getter
@Setter
public class PrdActivityCalendarQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 活动标题 精确
     */
    @ApiModelProperty("活动标题")
    private String title;
    /**
     * 活动类型 精确
     */
    @ApiModelProperty("活动类型")
    private String type;
    /**
     * 开始时间 精确
     */
    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;
    /**
     * 结束时间 精确
     */
    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;
    /**
     * 活动城市 精确
     */
    @ApiModelProperty("活动城市")
    private String city;
    /**
     * 活动地点 精确
     */
    @ApiModelProperty("活动地点")
    private String location;
    /**
     * 活动规模 精确
     */
    @ApiModelProperty("活动规模")
    private Integer scale;
    /**
     * 活动负责人 精确
     */
    @ApiModelProperty("活动负责人")
    private Long manageUserId;
    /**
     * 参与人 精确
     */
    @ApiModelProperty("参与人")
    private String participants;
    /**
     * 直播地址 精确
     */
    @ApiModelProperty("直播地址")
    private String liveUrl;

    /**
     * 项目时间年月
     */
    private String yearMonth;

    private LocalDate yearMonthDate;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate projectTime;
}
