package com.elitesland.tw.tw5.api.prd.schedule.sercvice;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdActivityCalendarPayload;
import com.elitesland.tw.tw5.api.prd.schedule.query.PrdActivityCalendarQuery;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdActivityCalendarAbleVO;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdActivityCalendarVO;

import java.util.List;

public interface PrdActivityCalendarService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PrdActivityCalendarVO}>
     */
    PagingVO<PrdActivityCalendarVO> queryPaging(PrdActivityCalendarQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PrdActivityCalendarVO}>
     */
    List<PrdActivityCalendarVO> queryListDynamic(PrdActivityCalendarQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PrdActivityCalendarVO}
     */
    PrdActivityCalendarVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdActivityCalendarVO}
     */
    PrdActivityCalendarVO insert(PrdActivityCalendarPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdActivityCalendarVO}
     */
    PrdActivityCalendarVO update(PrdActivityCalendarPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PrdActivityCalendarPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);


    PrdActivityCalendarAbleVO queryList(PrdActivityCalendarQuery query);

    void syncSchedule(Long id, String type);
}
