package com.elitesland.tw.tw5.api.prd.shorturl.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 短链服务请求记录
 *
 * @author duwh
 * @date 2023-05-19
 */
@Getter
@Setter
public class ShortUrlRequestLogQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** prd_short_url.id 精确 */
    @ApiModelProperty("prd_short_url.id")
    private Long shortId;
    /** 短链地址 精确 */
    @ApiModelProperty("短链地址")
    private String shortUrl;
    /** 长链地址 精确 */
    @ApiModelProperty("长链地址")
    private String longUrl;
    /** 参数 精确 */
    @ApiModelProperty("参数")
    private String params;
    /** ip来源 精确 */
    @ApiModelProperty("ip来源")
    private String requestIp;
    /** 耗时 精确 */
    @ApiModelProperty("耗时")
    private Long time;
    /** 请求所属地址 精确 */
    @ApiModelProperty("请求所属地址")
    private String address;
    /** 浏览器 精确 */
    @ApiModelProperty("浏览器")
    private String browser;
    /** 拓展1 精确 */
    @ApiModelProperty("拓展1")
    private String ext1;
    /** 拓展2 精确 */
    @ApiModelProperty("拓展2")
    private String ext2;
    /** 拓展3 精确 */
    @ApiModelProperty("拓展3")
    private String ext3;
    /** 拓展4 精确 */
    @ApiModelProperty("拓展4")
    private String ext4;
    /** 拓展5 精确 */
    @ApiModelProperty("拓展5")
    private String ext5;
}
