package com.elitesland.tw.tw5.api.prd.system.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)

public class PrdMessageConfigPayload extends TwCommonPayload {
    /**
     * 消息编号
     */
    @ApiModelProperty("消息编号")
    private String messageCode;
    /**
     * 消息标题
     */
    @ApiModelProperty("消息标题")
    private String messageTitle;
    /**
     * 消息内容
     */
    @ApiModelProperty("消息内容")
    private String messageContent;
    /**
     * 消息类别
     */
    @ApiModelProperty("内容类型")
    private String contentType;
    /**
     * 消息大类
     */
    @ApiModelProperty("消息类型")
    private String contentBigType;
    /**
     * 发布来源， （以谁的名义发布该条消息，默认是个人）
     */
    @ApiModelProperty("发布来源")
    private String releaseSource = "profileMessage";

    /**
     * 发布来源具体对象， （以谁的名义发布该条消息，个人，系统，组织，角色等，默认是个人）
     */
    private String createSource;

    /**
     * 以邮箱未参数，用这个邮箱发邮件，临时方案
     */
    @ApiModelProperty("发布邮箱")
    private String source;


    /**
     * 通知方式
     */
    @ApiModelProperty("通知方式")
    private String noticeWay;
    /**
     * 通知范围
     */
    @ApiModelProperty("通知范围")
    private String noticeScope;
    /**
     * 通知范围的关联项，如果选择角色，部门，个人 提交以','分割id或编号
     */
    @ApiModelProperty("通知资源")
    private String noticeSource;
    /**
     * 触发方式 定时，业务,默认是定时
     */
    @ApiModelProperty("触发方式")
    private String triggerWay = "timing";
    /**
     * 定时发布（触发时间表达式）
     */
    @ApiModelProperty("触发时间表达式")
    private String triggerTimeExpression;
    /**
     * 定时发布（单次发布具体时间）
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("定时发布（单次发布具体时间）")
    private LocalDateTime triggerTime;
    /**
     * 表达式说明
     */
    @ApiModelProperty("表达式说明")
    private String expressionExplain;
    /**
     * 消息标签
     */
    @ApiModelProperty("消息标签")
    private String messageTag;
    /**
     * 发布状态  0新建,1发布中(循环发布),2已撤回,3已发布
     */
    @ApiModelProperty("发布状态")
    private Integer releaseStatus = 0;
    /**
     * 资源类型  1:消息配置，2:消息发送
     */
    @ApiModelProperty("资源类型")
    private Integer messageType = 1;
    /**
     * 是否启用  0:启用，1：禁用
     */
    @ApiModelProperty("是否启用")
    private Integer isEnable = 0;

    /**
     * 业务数据id
     */
    private Long objectId;

    /**
     * 业务数据具体业务
     */
    private String action;
}
