package com.elitesland.tw.tw5.api.prd.system.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
    import java.time.LocalDate;
import java.util.List;

/**
 * 财务期间
 *
 * @author likunpeng
 * @date 2023-04-12
 */
@Getter
@Setter
public class PrdSystemFinPeriodQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 财务年度ID 精确 */
    @ApiModelProperty("财务年度ID")
    private Long finYearId;
    /** 财务期间 精确 */
    @ApiModelProperty("财务期间")
    private Integer finPeriod;
    /** 期间名称 模糊 */
    @ApiModelProperty("期间名称")
    private String periodName;
    /** 期间状态 精确 */
    @ApiModelProperty("期间状态")
    private String periodStatus;
    /** 开始日期 精确 */
    @ApiModelProperty("开始日期")
    private LocalDate beginDate;
    /** 结束日期 精确 */
    @ApiModelProperty("结束日期")
    private LocalDate endDate;
    /** 财务年度 */
    @ApiModelProperty("财务年度")
    private Integer finYear;
}
