package com.elitesland.tw.tw5.api.prd.system.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

@Data
public class PrdSystemProblemFeedbackQuery extends TwQueryParam {
    @ApiModelProperty("反馈标题")
    private String feedbackTitle;

    @ApiModelProperty("反馈状态")
    private String feedbackStatus;

    @ApiModelProperty("反馈时间开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startCreateTime;

    @ApiModelProperty("反馈时间结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endCreateTime;

    @ApiModelProperty("反馈处理时间开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startProcessCreateTime;

    @ApiModelProperty("反馈处理时间结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endProcessCreateTime;

    @ApiModelProperty("问题类型")
    private String problemType;

    @ApiModelProperty("所属功能")
    private Long functionId;

    @ApiModelProperty("负责人")
    private Long directorUserId;

    @ApiModelProperty("常用问题标识")
    private Integer commonFlag;

    @ApiModelProperty("问题反馈人")
    private Long createUserId;

    @ApiModelProperty("严重程度")
    private String level;

    @ApiModelProperty("回复状态")
    private String replyStatus;

    @ApiModelProperty("页面标志，用户页面0，管理员页面1")
    private Integer pageFlag;

    /**
     * 加急标识，0：不加急，1：加急
     */
    @ApiModelProperty("加急标识，0：不加急，1：加急")
    private Integer urgentFlag;


    /**
     * 运维管理员用户id
     */
    private Long opsAdmin;
}
