package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemGrossMarginPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemGrossMarginQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemGrossMarginVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 阶梯毛利率设置
 *
 * @author likunpeng
 * @date 2023-04-03
 */
public interface PrdSystemGrossMarginService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PrdSystemGrossMarginVO}>
     */
    PagingVO<PrdSystemGrossMarginVO> paging(PrdSystemGrossMarginQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PrdSystemGrossMarginVO}>
     */
    PagingVO<PrdSystemGrossMarginVO> queryPaging(PrdSystemGrossMarginQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PrdSystemGrossMarginVO}>
     */
    List<PrdSystemGrossMarginVO> queryList(PrdSystemGrossMarginQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PrdSystemGrossMarginVO}>
     */
    List<PrdSystemGrossMarginVO> queryListDynamic(PrdSystemGrossMarginQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PrdSystemGrossMarginVO}
     */
    PrdSystemGrossMarginVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdSystemGrossMarginVO}
     */
    PrdSystemGrossMarginVO insert(PrdSystemGrossMarginPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdSystemGrossMarginVO}
     */
    PrdSystemGrossMarginVO update(PrdSystemGrossMarginPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 逻辑删除
     * @param key
     * @return
     */
    void delete(Long key);
}
