package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemNewFunctionPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemNewFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemNewFunctionVO;

import java.util.List;
import java.util.Map;

/**
 * 业务对象 功能列表
 *
 * @Author Bill
 * @Date 2023/9/18 13:15
 **/
public interface PrdSystemNewFunctionService {

    /**
     * 业务对象 功能列表新增
     * @param payload
     * @return
     */
    PrdSystemNewFunctionVO insert(PrdSystemNewFunctionPayload payload);

    /**
     * 业务对象 功能列表编辑
     * @param payload
     * @return
     */
    PrdSystemNewFunctionVO update(PrdSystemNewFunctionPayload payload);

    /**
     * 业务对象 功能列表逻辑删除
     * @param longs
     */
    void deleteSoft(List<Long> longs);

    /**
     * 功能列表主键查询
     * @param id
     * @return
     */
    PrdSystemNewFunctionVO get(Long id);

    PagingVO<PrdSystemNewFunctionVO> paging(PrdSystemNewFunctionQuery query);

    /**
     * 功能列表 分页 keyword多列匹配
     * @param query
     * @return
     */
    PagingVO<PrdSystemNewFunctionVO> pagingKeyword(PrdSystemNewFunctionQuery query);

    /**
     * 项目启动 自动创建权限功能
     * @param functionMap key：业务对象编码 ，value：功能集合
     */
    void autoCreate(Map<String, List<PrdSystemNewFunctionPayload>> functionMap);

    /**
     * 业务对象 那些用户拥有该功能
     * @param query
     * @return
     */
    PagingVO<PrdOrgEmployeeVO> pagingUser(PrdOrgEmployeeQuery query);

    /**
     * 业务对象 功能下拉框
     * @param objectId
     * @return
     */
    List<PrdSystemNewFunctionVO> list(Long objectId);

    /**
     * 根据功能编码查询功能
     * @param functionCode
     * @return
     */
    PrdSystemNewFunctionVO getByFunctionCode(String functionCode);

    /**
     * 业务对象 可配置功能列表
     *
     * @param objectId
     * @return
     */
    List<PrdSystemNewFunctionVO> listFieldConfig(Long objectId);

    /**
     * 通过功能编码查询 业务对象主键
     *
     * @param codeRegx
     * @return
     */
    Long getObjectIdByFunctionCode(String codeRegx);
}
