package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemPermissionTableFieldsPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionTableFieldsQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionTableFieldsVO;

import java.util.List;

/**
 * 业务对象字段明细
 *
 * @author duwh
 * @date 2023-06-14
 */
public interface PrdSystemPermissionTableFieldsService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PrdSystemPermissionTableFieldsVO}>
     */
    PagingVO<PrdSystemPermissionTableFieldsVO> queryPaging(PrdSystemPermissionTableFieldsQuery query);

    /**
     * 查询数据库的表字段数据数据
     *
     * @param tableName 表名
     * @return {@link List}<{@link PrdSystemPermissionTableFieldsVO}>
     */
    List<PrdSystemPermissionTableFieldsVO> query(String tableName);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PrdSystemPermissionTableFieldsVO}
     */
    PrdSystemPermissionTableFieldsVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdSystemPermissionTableFieldsVO}
     */
    PrdSystemPermissionTableFieldsVO insert(PrdSystemPermissionTableFieldsPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdSystemPermissionTableFieldsVO}
     */
    PrdSystemPermissionTableFieldsVO update(PrdSystemPermissionTableFieldsPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PrdSystemPermissionTableFieldsPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PrdSystemPermissionTableFieldsVO}>
     */
    List<PrdSystemPermissionTableFieldsVO> queryListDynamic(PrdSystemPermissionTableFieldsQuery query);

}
