package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRoleGroupPayload;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRolePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleGroupQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleGroupVO;

import java.util.List;

/**
 * 角色组
 *
 * @Author Bill
 * @Date 2023/9/19 13:22
 **/
public interface PrdSystemRoleGroupService {

    /**
     * 角色组添加
     * @param payload
     * @return
     */
    PrdSystemRoleGroupVO insert(PrdSystemRoleGroupPayload payload);

    /**
     * 角色组修改
     * @param payload
     * @return
     */
    PrdSystemRoleGroupVO update(PrdSystemRoleGroupPayload payload);

    /**
     * 角色组逻辑删除
     * @param asList
     */
    void deleteSoft(List<Long> asList);

    /**
     * 角色组主键查询
     * @param id
     * @return
     */
    PrdSystemRoleGroupVO get(Long id);

    /**
     * 角色组列表
     * @param query
     * @return
     */
    List<PrdSystemRoleGroupVO> listGroup(PrdSystemRoleGroupQuery query);

    /**
     * 角色组列表查询全部
     * @Params roleGroupType 角色组类型
     * @return
     */
    List<PrdSystemRoleGroupVO> list(String roleGroupType);
}
