package com.elitesland.tw.tw5.api.prd.system.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSitePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSiteQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSiteVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 公共地点表
 *
 * @author zoey
 * @date 2024-04-22
 */
public interface PrdSystemSiteService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PrdSystemSiteVO}>
     */
    PagingVO<PrdSystemSiteVO> queryPaging(PrdSystemSiteQuery query);

    /**
     * 公共地点表-单纯分页,不关联业务单据
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PrdSystemSiteVO}>
     */
    PagingVO<PrdSystemSiteVO> queryPurPaging(PrdSystemSiteQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PrdSystemSiteVO}>
     */
    List<PrdSystemSiteVO> queryListDynamic(PrdSystemSiteQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PrdSystemSiteVO}
     */
    PrdSystemSiteVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdSystemSiteVO}
     */
    PrdSystemSiteVO insert(PrdSystemSitePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdSystemSiteVO}
     */
    PrdSystemSiteVO update(PrdSystemSitePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PrdSystemSitePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
