package com.elitesland.tw.tw5.api.prd.ts.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * notask_approval_1
 *
 * @author zoey
 * @date 2024-04-30
 */
@Getter
@Setter
public class TsNotaskApprovalConfigRulePayload extends TwCommonPayload  implements Serializable {
    /** 报配置主表id */
    @ApiModelProperty("报配置主表id")
    private Long configId;
    /** 活动 */
    @ApiModelProperty("活动")
    private String activity;
    /** 用户配置 */
    @ApiModelProperty("用户配置")
    private Integer isUser;
    /** 人员 */
    @ApiModelProperty("人员")
    private String users;
    /** 范围（udc:每人，事业部） */
    @ApiModelProperty("范围（udc:每人，事业部）")
    private String scope;
    /** 填报天数上限 */
    @ApiModelProperty("填报天数上限")
    private BigDecimal upperLimit;
    /** UT值 */
    @ApiModelProperty("UT值")
    private Integer ut;
    /** 触发条件 */
    @ApiModelProperty("触发条件")
    private String triggerCondition;
    /** 条件触发的天数 */
    @ApiModelProperty("条件触发的天数")
    private BigDecimal conditionDays;
    /** 审批人id */
    @ApiModelProperty("审批人id")
    private Long apprUserId;

    /** 审批1角色 */
    @ApiModelProperty("审批1角色")
    private String firstApprUserRole;


}
