package com.elitesland.tw.tw5.api.prd.ts.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 工时审批资源管理
 *
 * @author carl
 * @date 2024-05-04
 */
@Getter
@Setter
public class TsApprovalResQuery extends TwQueryParam implements Serializable {
    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private Long id;
    /**
     * 工时id 精确
     */
    @ApiModelProperty("工时id")
    private Long timesheetId;

    /**
     * 工时id 精确
     */
    @ApiModelProperty("工时id")
    private List<Long> timesheetIds;

    /**
     * 配置id 精确
     */
    @ApiModelProperty("配置id")
    private Long configId;
    /**
     * 审批资源id 精确
     */
    @ApiModelProperty("审批资源id")
    private Long approvalResId;
    /**
     * 审批状态 精确
     */
    @ApiModelProperty("审批状态")
    private String approvalStatus;
    /**
     * 审批资源描述(项目经理，交付负责人等) 精确
     */
    @ApiModelProperty("审批资源描述(项目经理，交付负责人等)")
    private String approvalSource;
    /**
     * 审批时间 精确
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvalTime;
    /**
     * 首次审批时间（前端不用） 精确
     */
    @ApiModelProperty("首次审批时间（前端不用）")
    private LocalDateTime fristApprovalTime;
    /**
     * 排序 精确
     */
    @ApiModelProperty("排序")
    private Integer sortIndex;
    /**
     * 最后审批人 精确
     */
    @ApiModelProperty("最后审批人")
    private Integer lastFlag;
}
