package com.elitesland.tw.tw5.api.prd.ts.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalConfigPayload;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalResPayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsApprovalConfigQuery;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalConfigVO;

import java.util.List;

/**
 * 工时审批配置管理
 *
 * @author carl
 * @date 2024-04-29
 */
public interface TsApprovalConfigService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TsApprovalConfigVO}>
     */
    PagingVO<TsApprovalConfigVO> queryPaging(TsApprovalConfigQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TsApprovalConfigVO}>
     */
    List<TsApprovalConfigVO> queryListDynamic(TsApprovalConfigQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TsApprovalConfigVO}
     */
    TsApprovalConfigVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TsApprovalConfigVO}
     */
    TsApprovalConfigVO insert(TsApprovalConfigPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TsApprovalConfigVO}
     */
    TsApprovalConfigVO update(TsApprovalConfigPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TsApprovalConfigPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据任务包id和工时提交年度获取审批资源
     *
     * @param taskPackageId
     * @return
     */
    List<TsApprovalResPayload> queryApprovalRes(Long taskPackageId, Integer finYear);

    List<TsApprovalResPayload> queryApprovalResDib(Long reasonId, String reasonType, Long tsUserId, Integer finYear);
}
