package com.elitesland.tw.tw5.api.prd.ts.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 工时审批配置管理
 *
 * @author carl
 * @date 2024-04-29
 */
@Getter
@Setter
@ToString
public class TsApprovalConfigVO extends BaseViewModel implements Serializable {
    /**
     * 年度
     */
    @ApiModelProperty("年度")
    private Integer finYear;
    /**
     * 成本级别
     */
    @ApiModelProperty("成本级别")
    private String costLevel;
    @UdcName(udcName = "PMS:PROJECT:COST_LEVEL", codePropName = "costLevel")
    private String costLevelDesc;
    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    private String reasonType;

    @UdcName(udcName = "PMS:PROJECT:TYPE", codePropName = "reasonType")
    private String reasonTypeDesc;
    /**
     * 工作类型
     */
    @ApiModelProperty("工作类型")
    private String workType;
    @UdcName(udcName = "salecon:work_type", codePropName = "workType")
    private String workTypeDesc;
    /**
     * 交付bu_id
     */
    @ApiModelProperty("交付bu_id")
    private Long deliBuId;
    @UdcName(udcName = "BU", codePropName = "deliBuId")
    private String deliBuName;
    /**
     * 资源类型（内外部）
     */
    @ApiModelProperty("资源类型（内外部）")
    private String resType;
    @UdcName(udcName = "org:employee:type", codePropName = "resType")
    private String resTypeDesc;
    /**
     * 预算类型（风险等级1，百分比2）
     */
    @ApiModelProperty("预算类型（风险等级1，百分比2）")
    private String budgetType;
    /**
     * 预算情况(风险等级)
     */
    @ApiModelProperty("预算情况(风险等级)")
    private String budgetData;
    /**
     * 预算情况(风险等级)
     */
    @ApiModelProperty("预算情况(风险等级)")
    private String budgetDataDesc;

    /**
     * 预算情况(百分比)
     */
    @ApiModelProperty("预算情况(百分比)")
    private BigDecimal budgetData0;
    /**
     * 审批类型1（指定角色1，指定用户2）
     */
    @ApiModelProperty("审批类型1（指定角色1，指定用户2）")
    private String approvalType1;
    /**
     * 审批资源1
     */
    @ApiModelProperty("审批资源1")
    private String approvalSource1;
    private String approvalSource1Desc;
    /**
     * 审批类型2
     */
    @ApiModelProperty("审批类型2")
    private String approvalType2;
    /**
     * 审批资源2
     */
    @ApiModelProperty("审批资源2")
    private String approvalSource2;
    private String approvalSource2Desc;
    /**
     * 审批类型3
     */
    @ApiModelProperty("审批类型3")
    private String approvalType3;
    /**
     * 审批资源3
     */
    @ApiModelProperty("审批资源3")
    private String approvalSource3;
    private String approvalSource3Desc;
    /**
     * 状态标记（有效1.无效0）
     */
    @ApiModelProperty("状态标记（有效1.无效0）")
    private Integer statusFlag;
}
