package com.elitesland.tw.tw5.api.prd.visit.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 销售拜访计划
 *
 * @author liwenpeng
 * @date 2023-03-14
 */
@Getter
@Setter
public class VisitPlanPayload extends TwCommonPayload  implements Serializable {
    /** 计划类型 */
    @ApiModelProperty("计划类型")
    private String visitPlanType;

    /** 计划状态 */
    @ApiModelProperty("计划状态")
    private String visitPlanStatus;

    /** 计划名称 */
    @ApiModelProperty("计划名称")
    private String visitPlanName;

    /** 拜访客户id see partnerId */
    @ApiModelProperty("拜访客户id see partnerId")
    @Deprecated
    private Long customId;

    /** 业务伙伴主键（客户主表） business_partner.id */
    @ApiModelProperty("业务伙伴主键（客户主表） business_partner.id")
    private Long partnerId;

    /** 客户地址 */
    @ApiModelProperty("客户地址")
    private String customAdress;
    /** 经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标 */
    @ApiModelProperty("经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标")
    private String longitudeLatitude;

    /** 业务合作伙伴-地址信息ID */
    @ApiModelProperty("业务合作伙伴-地址信息ID")
    private Long bookAddressId;

    /** 拜访时间 */
    @ApiModelProperty("拜访时间")
    private LocalDate visitDateFrom;

    /** 拜访时间 */
    @ApiModelProperty("拜访时间")
    private LocalDate visitDateTo;

    /** 拜访次数 */
    @ApiModelProperty("拜访次数")
    private String visitTimes;

    /** 添加提醒 */
    @ApiModelProperty("添加提醒")
    private LocalDateTime remindTime;
    private String extString1;
    private String extString2;
    private String extString3;
    private String extString4;
    private String extString5;

    /** 关联信息类型（线索、商机OPPO、经营计划、销售目标） */
    @ApiModelProperty("关联信息类型（线索、商机OPPO、经营计划、销售目标）")
    private String objType;

    /** 关联信息主键（关联主键) */
    @ApiModelProperty("关联信息主键（关联主键)")
    private Long objId;

    /** 关联信息名称（冗余） */
    @ApiModelProperty("关联信息名称（冗余）")
    private String objName;

    /** 拜访人员列表 */
    private List<Long> visitPersonList;

    /** 协访人员列表 */
    private List<Long> accompanyPersonList;
}
