package com.elitesland.tw.tw5.api.prd.visit.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

/**
 * 销售拜访计划
 *
 * @author liwenpeng
 * @date 2023-03-14
 */
@Getter
@Setter
public class VisitPlanQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    @Query
    private Long id;

    /**
     * 计划类型 精确
     */
    @ApiModelProperty("计划类型")
    @Query
    private String visitPlanType;

    @ApiModelProperty("计划状态")
    @Query
    private String visitPlanStatus;

    /**
     * 计划名称 模糊
     */
    @ApiModelProperty("计划名称")
    @Query(type = Query.Type.INNER_LIKE)
    private String visitPlanName;

    /**
     * 拜访客户id see partnerId
     */
    @ApiModelProperty("拜访客户id see partnerId")
    @Deprecated
    private Long customId;

    /**
     * 业务伙伴主键（客户主表） business_partner.id
     */
    @ApiModelProperty("业务伙伴主键（客户主表） business_partner.id")
    private Long partnerId;

    /**
     * 客户地址 模糊
     */
    @ApiModelProperty("客户地址")
    @Query(type = Query.Type.INNER_LIKE)
    private String customAdress;

    /**
     * 业务合作伙伴-地址信息ID
     */
    @ApiModelProperty("业务合作伙伴-地址信息ID")
    private Long bookAddressId;

    /**
     * 拜访次数 精确
     */
    @ApiModelProperty("拜访次数")
    @Query
    private String visitTimes;

    /**
     * 关联信息类型（线索、商机OPPO、经营计划、销售目标） 精确
     */
    @ApiModelProperty("关联信息类型（线索、商机OPPO、经营计划、销售目标）")
    @Query
    private String objType;

    /**
     * 关联信息主键（关联主键) 精确
     */
    @ApiModelProperty("关联信息主键（关联主键)")
    @Query
    private Long objId;

    /**
     * 关联信息名称（冗余） 模糊
     */
    @ApiModelProperty("关联信息名称（冗余）")
    @Query(type = Query.Type.INNER_LIKE)
    private String objName;

    /**
     * 拜访时间 BETWEEN
     */
    @ApiModelProperty("拜访时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate visitDateFrom;

    /**
     * 拜访时间 BETWEEN
     */
    @ApiModelProperty("拜访时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate visitDateTo;

    /**
     * 添加提醒 BETWEEN
     */
    @ApiModelProperty("添加提醒")
    private LocalDateTime remindTime;

    /**
     * 拜访人员列表
     */
    private Long visitPerson;
    private String visitPersonNameStr;

    /**
     * 协访员列表
     */
    private Long accompanyPerson;
    private String accompanyPersonNameStr;

    /**
     * 需要权限
     */
    private Boolean permissionFlag = false;
    /**
     * 下属id集合
     */
    private Set<Long> subordinatesIds;


    private Long LoginUserId;
    /**
     * 销售资源角色userId集合
     */
    private List<Long> saleUserIds;
}
