package com.elitesland.tw.tw5.api.prd.visit.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitPlanDetailPayload;
import com.elitesland.tw.tw5.api.prd.visit.query.VisitPlanDetailQuery;
import com.elitesland.tw.tw5.api.prd.visit.vo.VisitPlanDetailVO;


import java.util.List;

/**
 * 销售拜访计划成员
 *
 * @author liwenpeng
 * @date 2023-03-14
 */
public interface VisitPlanDetailService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link VisitPlanDetailVO}>
     */
    PagingVO<VisitPlanDetailVO> paging(VisitPlanDetailQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link VisitPlanDetailVO}>
     */
    PagingVO<VisitPlanDetailVO> queryPaging(VisitPlanDetailQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link VisitPlanDetailVO}>
     */
    List<VisitPlanDetailVO> queryList(VisitPlanDetailQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link VisitPlanDetailVO}>
     */
    List<VisitPlanDetailVO> queryListDynamic(VisitPlanDetailQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link VisitPlanDetailVO}
     */
    VisitPlanDetailVO queryByKey(Long key);

    /**
    * 新增
    *
    * @param payload 单据数据
    * @return {@link VisitPlanDetailVO}
    */
    VisitPlanDetailVO insert(VisitPlanDetailPayload payload);

    /**
    * 修改
    *
    * @param payload 单据数据
    * @return {@link VisitPlanDetailVO}
    */
    VisitPlanDetailVO update(VisitPlanDetailPayload payload);

    /**
    * 逻辑删除
    *
    * @param keys 主键集合
    */
    void deleteSoft(List<Long> keys);

}
