package com.elitesland.tw.tw5.api.prd.visit.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAddressVO;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitPlanAutoListPayload;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitPlanAutoPayload;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitPlanPayload;
import com.elitesland.tw.tw5.api.prd.visit.query.VisitPlanQuery;
import com.elitesland.tw.tw5.api.prd.visit.vo.VisitPlanVO;


import java.util.List;
import java.util.Map;

/**
 * 销售拜访计划
 *
 * @author liwenpeng
 * @date 2023-03-14
 */
public interface VisitPlanService {


    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link VisitPlanVO}>
     */
    PagingVO<VisitPlanVO> queryPaging(VisitPlanQuery query);


    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link VisitPlanVO}
     */
    VisitPlanVO queryByKey(Long key);

    /**
    * 新增
    *
    * @param payload 单据数据
    * @return {@link VisitPlanVO}
    */
    VisitPlanVO insert(VisitPlanPayload payload);

    /**
     * 自动创建拜访计划 （附近的客户）
     *
     * @param visitPlanAutoPayload 单据数据
     * @return {@link VisitPlanVO}
     */
    VisitPlanVO insertAuto(VisitPlanAutoPayload visitPlanAutoPayload);


    /**
     * 批量新增拜访计划（附近的客户）
     *
     * @param payload 有效载荷
     * @return {@link Object}
     */
    List<VisitPlanVO> insertListAuto(VisitPlanAutoListPayload payload);

    /**
    * 修改
    *
    * @param payload 单据数据
    * @return {@link VisitPlanVO}
    */
    long update(VisitPlanPayload payload);
    /**
     * 完成计划
     *
     * @param
     * @return {@link VisitPlanVO}
     */
    long completeVisitPlan(Long visitPlanId);

    /**
    * 逻辑删除
    *
    * @param keys 主键集合
    */
    void deleteSoft(List<Long> keys);

//    /**
//     * 验证拜访计划名称
//     * @param visitPlanName
//     * @return
//     */
//    int verifyVisitPlanName(String visitPlanName);


    /**
     * 拜访计划情况统计
     * @return
     */
    Map<String,Integer> visitPlanCount();

    /**
     * 拜访计划 根据选择客户获得客户详细地址
     * @param bookId
     * @return
     */
    String getVisitCustomAddress(Long bookId);

    /**
     * 拜访计划 根据选择客户获得客户详细地址
     * @param bookId
     * @return  List<BookAddressVO>
     */
    List<BookAddressVO> getVisitCustomAddressList(Long bookId);

    Object visitCustomRelationInfo(Long partnerId,String objType);

}
