package com.elitesland.tw.tw5.server.common.util;

import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * sql工具类
 *
 * @author zhangyongqiang
 */
public class SqlUtil {

    public static String toSqlLikeString(String value) {
        return "%" + value + "%";
    }

    private static List<OrderItem> orderse = null;

    public static List<OrderItem> getOrderse() {
        if (orderse == null) {
            orderse = new ArrayList<>();
            orderse.add(OrderItem.asc("sortIndex"));
            orderse.add(OrderItem.desc("createTime"));
        }
        return orderse;
    }

    /**
     * 自定义分页时的排序字段
     *
     * @param pathBase Q对象
     * @param orders   排序数据
     * @return 排序order
     */
    public static <T> OrderSpecifier<?>[] getSortedColumn(EntityPathBase<T> pathBase, List<OrderItem> orders) {
        if (orders == null || orders.size() == 0) {
            Path<String> fieldPath = Expressions.path(String.class, pathBase, "createTime");
            return new OrderSpecifier[]{new OrderSpecifier<>(Order.DESC, fieldPath)};
        } else {
            OrderSpecifier<String>[] orderSpecifiers = new OrderSpecifier[orders.size()];
            for (int i = 0; i < orders.size(); i++) {
                OrderItem orderItem = orders.get(i);
                Order order = orderItem.isAsc() ? Order.ASC : Order.DESC;
                Path<String> fieldPath = Expressions.path(String.class, pathBase, orderItem.getColumn());
                orderSpecifiers[i] = new OrderSpecifier<>(order, fieldPath);
            }
            return orderSpecifiers;
        }
    }

    /**
     * 常用基础查询条件拼装
     *
     * @param jpaQuery   jpaQuery对象
     * @param qBaseModel qBaseModel
     * @param query      查询条件
     * @param <T>        范型对象
     */
    public static <T> void handleCommonJpaQuery(JPAQuery<T> jpaQuery, QBaseModel qBaseModel, TwQueryParam query) {
        jpaQuery.where(qBaseModel.deleteFlag.eq(0));
        if (!ObjectUtils.isEmpty(query.getId())) {
            jpaQuery.where(qBaseModel.id.eq(query.getId()));
        }
        if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
            jpaQuery.where(qBaseModel.createUserId.eq(query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getCreateTimeStart())) {
            jpaQuery.where(qBaseModel.createTime.goe(query.getCreateTimeStart()));
        }
        if (!ObjectUtils.isEmpty(query.getCreateTimeEnd())) {
            jpaQuery.where(qBaseModel.createTime.loe(query.getCreateTimeEnd()));
        }
        if (!ObjectUtils.isEmpty(query.getRemark())) {
            jpaQuery.where(qBaseModel.remark.like(SqlUtil.toSqlLikeString(query.getRemark())));
        }
    }

    /**
     * 必要的更新字段
     *
     * @param update     更新语句
     * @param qBaseModel 更新对象
     */
    public static void updateCommonJpaQuery(JPAUpdateClause update, QBaseModel qBaseModel) {
        SysUserDTO userDTO = AuthContextUtil.getLoginUser();
        update.set(qBaseModel.modifyUserId, userDTO.getId());
        update.set(qBaseModel.updater, userDTO.getFirstName());
        update.set(qBaseModel.modifyTime, LocalDateTime.now());
    }
}
