package com.elitesland.tw.tw5.server.demo.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.demo.query.DemoCompanyBankQuery;
import com.elitesland.tw.tw5.api.demo.vo.DemoCompanyBankVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.demo.entity.QDemoBankDO;
import com.elitesland.tw.tw5.server.demo.entity.QDemoCompanyDO;
import com.elitesland.tw.tw5.server.demo.repo.DemoCompanyRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

/**
 * 标准样例dao
 *
 * @author zhangyongqiang
 */
@Repository
@RequiredArgsConstructor
public class DemoCompanyDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final DemoCompanyRepo repo;
    private final QDemoBankDO qbank = QDemoBankDO.demoBankDO;
    private final QDemoCompanyDO qcompany = QDemoCompanyDO.demoCompanyDO;
    /**
     * 拼装查询字段
     * @return  jpaQuery对象
     */
    private JPAQuery<DemoCompanyBankVO> getJpaQuerySelect() {
        JPAQuery<DemoCompanyBankVO> jpaQuery=jpaQueryFactory.select(Projections.bean(DemoCompanyBankVO.class,

                qcompany.companyAddr,
                qcompany.companyName,
                qcompany.companyMobile,
                qbank.bankName,
                qbank.bankCard,
                qbank.handleName,
                qbank.id.as("bankId"),
                qbank.companyId
        )).from(qcompany).leftJoin(qbank).on(qcompany.id.longValue().eq(qbank.companyId));


        return jpaQuery;
    }

    /**
     * 拼装查询条件
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<DemoCompanyBankVO> getJpaQueryWhere(DemoCompanyBankQuery query) {
        JPAQuery<DemoCompanyBankVO> jpaQuery = getJpaQuerySelect();

        if (!ObjectUtils.isEmpty(query.getCompanyAddr())) {
            jpaQuery.where(qcompany.companyAddr.like(SqlUtil.toSqlLikeString(query.getCompanyAddr())));
        }
        if (!ObjectUtils.isEmpty(query.getCompanyName())) {
            jpaQuery.where(qcompany.companyName.like(SqlUtil.toSqlLikeString(query.getCompanyName())));
        }
        if (!ObjectUtils.isEmpty(query.getCompanyMobile())) {
            jpaQuery.where(qcompany.companyMobile.like(SqlUtil.toSqlLikeString(query.getCompanyMobile())));
        }
        if (!ObjectUtils.isEmpty(query.getBankCard())) {
            jpaQuery.where(qbank.bankCard.like(SqlUtil.toSqlLikeString(query.getBankCard())));
        }
        if (!ObjectUtils.isEmpty(query.getHandleName())) {
            jpaQuery.where(qbank.handleName.like(SqlUtil.toSqlLikeString(query.getHandleName())));
        }
        if (!ObjectUtils.isEmpty(query.getBankName())) {
            jpaQuery.where(qbank.bankName.like(SqlUtil.toSqlLikeString(query.getBankName())));
        }
        if (!ObjectUtils.isEmpty(query.getBankId())) {
            jpaQuery.where(qbank.id.eq(query.getBankId()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery,qcompany._super,query);

        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qcompany,query.getOrders()));

        return jpaQuery;
    }

    /**
     * 根据主键查询
     * @param id 主键
     * @return 结果
     */
    public DemoCompanyBankVO queryByKey(Long id){
        JPAQuery<DemoCompanyBankVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qcompany.id.eq(id));
        return jpaQuery.fetchFirst();
    }



    /**
     * 分页查询
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<DemoCompanyBankVO> queryPaging(DemoCompanyBankQuery query){
        JPAQuery<DemoCompanyBankVO> jpaQuery = getJpaQueryWhere(query);

        QueryResults<DemoCompanyBankVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        System.out.println(result.getTotal());
        return PagingVO.<DemoCompanyBankVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }





}
