package com.elitesland.tw.tw5.server.demo.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 简单样例DO
 * @author zhangyongqiang
 */
// 指定数据库是哪个表
@Entity(name = "demo_company")
// 生产数据库表
@Table(name = "demo_company")
// 为表增加注释字段
@org.hibernate.annotations.Table(appliesTo = "demo_company", comment = "公司表")
@Getter
@Setter
@Where(clause = " delete_flag = 0 ")
public class DemoCompanyDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 1L;
    @Comment("公司地址")
    @Column(nullable = false, length = 100)
    private String companyAddr;

    @Comment("公司名称")
    @Column(nullable = false, length = 50)
    private String companyName;

    @Comment("公司电话")
    @Column(nullable = false, length = 20)
    private String companyMobile;

}
