package com.elitesland.tw.tw5.server.demo.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 简单样例DO
 * @author zhangyongqiang
 */
// 指定数据库是哪个表
@Entity(name = "demo_simple2")
// 生产数据库表
@Table(name = "demo_simple2")
// 为表增加注释字段
@org.hibernate.annotations.Table(appliesTo = "demo_simple2", comment = "简单样例表")
@Getter
@Setter
@Where(clause = " delete_flag = 0 ")
public class DemoSimpleDO extends BaseModel implements Serializable {
    @Comment("对象编号")
    @Column()
    private String objectNo;

    @Comment("对象名称")
    @Column()
    private String objectName;

    @Comment("属性1")
    private String attribute1;

    @Comment("属性2")
    private String attribute2;

    @Comment("属性3")
    private String attribute3;

    @Comment("属性4")
    private String attribute4;

    @Comment("属性5")
    private String attribute5;


    @Comment("对象状态")
    private String objectStatus;

    @Comment("流程提交标志")
    private Boolean sbmit;

    @Comment("流程实例ID")
    private String procInstId;

    @Column
    @Comment("流程实例状态")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Comment("提交时间")
    @Column
    private LocalDateTime submitTime;

    @Comment("审批通过时间")
    @Column
    private LocalDateTime approvedTime;


}
