/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.param.SysPasswordUpdate;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitesland.tw.tw5.api.prd.app.vo.PrdUserDataForAppVO;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserCompositeVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserDataVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserRemindVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TwRecentTaskVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TwRecentWorkVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemProblemFeedbackService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemMenuVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.PrdUserRemindDO;
import com.elitesland.tw.tw5.server.prd.qixin.config.QiXinProperties;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PrdUserServiceImpl
implements PrdUserService {
    private static final Logger log = LoggerFactory.getLogger(PrdUserServiceImpl.class);
    private final PrdUserDAO dao;
    private final CacheUtil cacheUtil;
    private final FileUtil fileUtil;
    private final PrdSystemProblemFeedbackService prdSystemProblemFeedbackService;
    @Autowired
    private SysUserRpcService sysUserService;
    @Value(value="${tw5.workflow.enabled:false}")
    private Boolean workflow_enabled;
    private final QiXinProperties qiXinProperties;

    public List<PrdUserCompositeVO> queryUserComposite(Long userId) {
        List<PrdUserCompositeVO> prdUserCompositeVOS = this.dao.queryUserComposite(userId);
        prdUserCompositeVOS.forEach(compositeVO -> {
            compositeVO.setManageLevelName(this.cacheUtil.transferSystemSelection("org:employee:manage", compositeVO.getManageLevel()));
            compositeVO.setWorkTypeName(this.cacheUtil.transferSystemSelection("org:employee:worktype", compositeVO.getWorkType()));
            PrdSystemSelectionVO prdSystemSelectionVO = this.cacheUtil.transferSystemSelectionObj("org:employee:specialtylevel", compositeVO.getSpecialtyLevel());
            if (prdSystemSelectionVO != null) {
                compositeVO.setSpecialtyLevelName(prdSystemSelectionVO.getSelectionName());
                compositeVO.setEqvaRatio(BigDecimal.valueOf(100L));
                if (StringUtils.hasText((String)prdSystemSelectionVO.getExtString1())) {
                    compositeVO.setEqvaRatio(new BigDecimal(String.valueOf(prdSystemSelectionVO.getExtString1())));
                }
            }
        });
        return prdUserCompositeVOS;
    }

    @Transactional
    public PrdUserDataVO queryUserDetail() {
        Long userId = GlobalUtil.getLoginUserId();
        PrdUserDataVO vo = this.dao.queryUserDetail(userId);
        vo.setHeadDatas(this.fileUtil.getFileDatas(vo.getHeadCodes()));
        vo.setOrgRoles(this.dao.queryRolesById("" + userId));
        List<PrdSystemShortcutVO> shortcutVOs = this.dao.queryShortcutList();
        if (!CollectionUtils.isEmpty(shortcutVOs)) {
            if (StringUtils.hasText((String)vo.getShortcutIds())) {
                shortcutVOs.forEach(shortcutVO -> {
                    if (vo.getShortcutIds().contains("" + shortcutVO.getId())) {
                        shortcutVO.setIsMy(Integer.valueOf(0));
                    }
                });
            }
            vo.setShortcutVOs(shortcutVOs);
        }
        String ticket = UUID.randomUUID().toString();
        vo.setTicket(new String(Base64.encodeBase64((byte[])ticket.getBytes())));
        this.transferSystemSelection(vo);
        this.dao.updateTicket(vo.getId(), ticket);
        vo.setWorkflowEnabled(this.workflow_enabled);
        vo.setQxBEnabled(this.qiXinProperties.getEnabled());
        return vo;
    }

    public PrdUserDataForAppVO queryDetailForMobile() {
        Long userId = GlobalUtil.getLoginUserId();
        PrdUserDataForAppVO vo = this.dao.queryUserDetailForApp(userId);
        vo.setJobsName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeJobs.getCode(), vo.getJobs()));
        vo.setSexName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeSex.getCode(), vo.getSex()));
        vo.setWorkflowEnabled(this.workflow_enabled);
        return vo;
    }

    @Transactional
    public Long updateShortcut(String shortcutIds) {
        Long userId = GlobalUtil.getLoginUserId();
        return this.dao.updateShortcut(userId, shortcutIds);
    }

    public void updatePassword(String oldPassword, String newPassword) {
        if (!StringUtils.hasText((String)oldPassword) || !StringUtils.hasText((String)newPassword)) {
            throw TwException.error("", "\u65e0\u6548\u7684\u5bc6\u7801");
        }
        Long userId = GlobalUtil.getLoginUserId();
        SysPasswordUpdate passwordUpdate = new SysPasswordUpdate();
        passwordUpdate.setUserId(userId);
        passwordUpdate.setCurrentPassword(new String(Base64.encodeBase64((byte[])oldPassword.getBytes())));
        passwordUpdate.setNewPassword(new String(Base64.encodeBase64((byte[])newPassword.getBytes())));
        this.sysUserService.updatePassword(passwordUpdate);
    }

    public List<TwRecentWorkVO> findMyWork() {
        Long userId = GlobalUtil.getLoginUserId();
        ArrayList<TwRecentWorkVO> recentWorkVOList = new ArrayList<TwRecentWorkVO>();
        this.problemFeedback(recentWorkVOList, userId);
        return recentWorkVOList;
    }

    public List<TwRecentTaskVO> findMyTask() {
        ArrayList<TwRecentTaskVO> recentTaskVOList = new ArrayList<TwRecentTaskVO>();
        return recentTaskVOList;
    }

    public List<PrdUserRemindVO> findMyRemind() {
        Long userId = GlobalUtil.getLoginUserId();
        LocalDate newDate = LocalDate.now();
        ArrayList<PrdUserRemindVO> resRemindVOS = new ArrayList<PrdUserRemindVO>();
        List<PrdUserRemindVO> remindVOS = this.dao.queryReminds(userId);
        for (PrdUserRemindVO remindVO : remindVOS) {
            if (remindVO.getNoRemindDate() != null && remindVO.getNoRemindDate().equals(newDate)) continue;
            String string = remindVO.getRemindType();
        }
        return resRemindVOS;
    }

    @Transactional
    public Boolean updateMyRemind(String remindType) {
        Long userId = GlobalUtil.getLoginUserId();
        LocalDate newDate = LocalDate.now();
        PrdUserRemindDO userRemindDO = this.dao.queryUserRemind(userId, remindType);
        if (userRemindDO == null) {
            userRemindDO = new PrdUserRemindDO();
            userRemindDO.setRemindType(remindType);
            userRemindDO.setUserId(userId);
        }
        userRemindDO.setNoRemindDate(newDate);
        this.dao.saveUserRemind(userRemindDO);
        return true;
    }

    public void queryUserByTicket(HttpServletRequest request, HttpServletResponse response) {
        String ticket = request.getParameter("ticket");
        if (ticket != null && !ticket.isEmpty()) {
            ticket = new String(Base64.decodeBase64((byte[])ticket.getBytes()));
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        JSONObject jsonObject = null;
        HttpSession session = request.getSession();
        PrdUserDataVO info = this.dao.queryUserByTicket(ticket);
        try {
            if (info == null) {
                paramMap.put("el-result-cod", "NG_UNSUPPORTED");
                paramMap.put("statusCode", "401");
                jsonObject = new JSONObject(paramMap);
                response.setStatus(401);
                session.setAttribute("paramMap", paramMap);
            }
            paramMap.put("app_login_type", "SSO");
            paramMap.put("app_login_id", info.getId());
            paramMap.put("app_login_email", info.getEmail());
            paramMap.put("app_login_ticket", ticket);
            paramMap.put("el-result-cod", "OK");
            paramMap.put("statusCode", "200");
            jsonObject = new JSONObject(paramMap);
            response.setStatus(200);
            session.setAttribute("paramMap", paramMap);
            response.getWriter().print(jsonObject);
        }
        catch (NullPointerException e) {
            try {
                response.getWriter().print(jsonObject);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<PrdOrgDataRefVO> queryOrgList() {
        Long userId = GlobalUtil.getLoginUserId();
        return this.dao.queryOrgListByKey(userId);
    }

    public List<PrdOrgEmployeeRefVO> queryLowListByKey(Long orgId) {
        Long userId = GlobalUtil.getLoginUserId();
        return this.dao.queryLowListByKey(orgId, userId);
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public List<PrdSystemMenuVO> queryMenus() {
        List<PrdSystemMenuVO> menuVOS = this.dao.queryUsableList();
        GeneralUserDetails loginGeneralUser = GlobalUtil.getLoginGeneralUser();
        if (loginGeneralUser.isSystemAdmin()) {
            return menuVOS;
        }
        if (loginGeneralUser.isTenantAdmin()) {
            return menuVOS.stream().filter(menuVO_ -> !menuVO_.getPortalRoute().contains("/tenancy")).collect(Collectors.toList());
        }
        List<Long> userMenuIds = this.dao.queryUserMenuIds(loginGeneralUser.getUserId());
        return menuVOS.stream().filter(menuVO -> userMenuIds.indexOf(menuVO.getId()) >= 0).collect(Collectors.toList());
    }

    private void problemFeedback(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        long num = this.prdSystemProblemFeedbackService.findWorkProblemFeedbackByUserId(Long.valueOf(userId));
        if (num > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)"\u95ee\u9898\u53cd\u9988", (Long)num, (String)TwRecentWorkVO.RecentWorkType.FEED_BACK.getCode()));
        }
    }

    void transferSystemSelection(PrdUserDataVO vo) {
        vo.setJobsName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeJobs.getCode(), vo.getJobs()));
    }

    public PrdUserServiceImpl(PrdUserDAO dao, CacheUtil cacheUtil, FileUtil fileUtil, PrdSystemProblemFeedbackService prdSystemProblemFeedbackService, QiXinProperties qiXinProperties) {
        this.dao = dao;
        this.cacheUtil = cacheUtil;
        this.fileUtil = fileUtil;
        this.prdSystemProblemFeedbackService = prdSystemProblemFeedbackService;
        this.qiXinProperties = qiXinProperties;
    }
}

