/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSelectionPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSelectionQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRemindService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemSelectionConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemSelectionDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemSelectionDO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdSystemSelectionServiceImpl
extends BaseServiceImpl
implements PrdSystemSelectionService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemSelectionServiceImpl.class);
    private final PrdSystemSelectionDAO dao;
    private final CacheUtil cacheUtil;
    private final PrdSystemRemindService remindService;

    @Transactional
    public PrdSystemSelectionVO insert(PrdSystemSelectionPayload payload) {
        payload.setSelectionKey(payload.getSelectionKey().trim());
        payload.setSelectionValue(payload.getSelectionValue().trim());
        String remindCode = "SYS:E:SYSTEM_SELECTION_KEY_NOT_REPEAT";
        boolean allowReturn = this.remindService.allowReturn(remindCode, (TwCommonPayload)payload);
        if (allowReturn) {
            PrdSystemSelectionQuery query = new PrdSystemSelectionQuery();
            query.setSelectionKey(payload.getSelectionKey());
            int count = this.dao.queryListDynamic(query).size();
            if (count > 0) {
                throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
            }
        }
        PrdSystemSelectionDO ado = PrdSystemSelectionConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        this.cacheUtil.loadSystemSelectionCache();
        return PrdSystemSelectionConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public Long update(PrdSystemSelectionPayload payload) {
        payload.setSelectionKey(payload.getSelectionKey().trim());
        payload.setSelectionValue(payload.getSelectionValue().trim());
        String remindCode = "SYS:E:SYSTEM_SELECTION_KEY_NOT_REPEAT";
        boolean allowReturn = this.remindService.allowReturn(remindCode, (TwCommonPayload)payload);
        if (allowReturn) {
            PrdSystemSelectionQuery query = new PrdSystemSelectionQuery();
            query.setSelectionKey(payload.getSelectionKey());
            query.setId(payload.getId());
            int count = this.dao.queryListDynamic(query).size();
            if (count > 0) {
                throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
            }
        }
        this.dao.updateByKeyDynamic(payload);
        this.cacheUtil.loadSystemSelectionCache();
        return 0L;
    }

    @Transactional
    public boolean delete(List<Long> keys) {
        this.dao.delete(keys);
        this.cacheUtil.loadSystemSelectionCache();
        return true;
    }

    @Transactional
    public boolean deleteSoft(List<Long> keys) {
        this.dao.deleteSoft(keys);
        this.cacheUtil.loadSystemSelectionCache();
        return true;
    }

    public PrdSystemSelectionVO queryByKey(Long key) {
        return this.dao.queryByKey(key);
    }

    public PagingVO<PrdSystemSelectionVO> paging(PrdSystemSelectionQuery query) {
        return this.dao.queryPaging(query);
    }

    public List<PrdSystemSelectionVO> selectByCondition(String key) {
        PrdSystemSelectionVO view = this.cacheUtil.getSystemSelection(key);
        if (view == null || view.getChildren() == null || view.getChildren().isEmpty()) {
            return new ArrayList<PrdSystemSelectionVO>();
        }
        List children = view.getChildren();
        ArrayList list = new ArrayList(children.size());
        children.forEach(selectionView -> list.add(selectionView.clone()));
        list.forEach(selectionView -> selectionView.setChildren(null));
        List<PrdSystemSelectionVO> collect = list.stream().sorted(Comparator.comparing(selectionView -> selectionView.getSortNo() == null ? Integer.MAX_VALUE : selectionView.getSortNo())).collect(Collectors.toList());
        return collect;
    }

    public List<PrdSystemSelectionVO> queryList(PrdSystemSelectionQuery query) {
        return this.dao.queryListDynamic(query);
    }

    public List<PrdSystemSelectionVO> getSystemSelectionChildrenList(PrdSystemSelectionQuery query) {
        PrdSystemSelectionVO view = this.cacheUtil.getSystemSelection(query.getParentSelectionKey());
        if (view == null || view.getChildren() == null || view.getChildren().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PrdSystemSelectionVO> allChildren = new ArrayList<PrdSystemSelectionVO>();
        this.cacheUtil.getAllChildren(view, allChildren);
        List<PrdSystemSelectionVO> filtedList = this.filte(allChildren, query);
        List<PrdSystemSelectionVO> cloneList = filtedList.stream().map(PrdSystemSelectionVO::clone).collect(Collectors.toList());
        cloneList.forEach(prdSystemSelectionVO -> prdSystemSelectionVO.setChildren(null));
        return cloneList;
    }

    List<PrdSystemSelectionVO> filte(List<PrdSystemSelectionVO> list, PrdSystemSelectionQuery query) {
        Stream<Object> stream = list.stream();
        if (StringUtils.isNotBlank((CharSequence)query.getSelectionName())) {
            stream = stream.filter(prdSystemSelectionVO -> query.getSelectionName().equals(prdSystemSelectionVO.getSelectionName()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getSelectionValue())) {
            stream = stream.filter(prdSystemSelectionVO -> query.getSelectionValue().equals(prdSystemSelectionVO.getSelectionValue()));
        }
        if (query.getParentId() != null) {
            stream = stream.filter(prdSystemSelectionVO -> query.getParentId().equals(prdSystemSelectionVO.getParentId()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getExtString10())) {
            stream = stream.filter(prdSystemSelectionVO -> query.getExtString10().equals(prdSystemSelectionVO.getExtString10()));
        }
        return stream.collect(Collectors.toList());
    }

    public PrdSystemSelectionServiceImpl(PrdSystemSelectionDAO dao, CacheUtil cacheUtil, PrdSystemRemindService remindService) {
        this.dao = dao;
        this.cacheUtil = cacheUtil;
        this.remindService = remindService;
    }
}

