/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.udc;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.udc.UdcDTO;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcTypeEnum;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class UdcAspect {
    private static final Logger log = LoggerFactory.getLogger(UdcAspect.class);
    private final CacheUtil cacheUtil;
    private static final String COLLECTION_FIELD_TYPE = "Collection";

    public UdcAspect(CacheUtil cacheUtil) {
        this.cacheUtil = cacheUtil;
    }

    @Around(value="@annotation(udcNameClass)")
    public Object translation(ProceedingJoinPoint pjp, UdcNameClass udcNameClass) throws Throwable {
        Object resultR = pjp.proceed();
        if (ObjectUtil.isNull((Object)resultR)) {
            return resultR;
        }
        if (resultR instanceof TwOutputUtil) {
            return this.translation((TwOutputUtil)resultR);
        }
        return resultR;
    }

    public TwOutputUtil translation(TwOutputUtil twOutput) {
        Object data = twOutput.getData();
        if (data instanceof PagingVO) {
            List list = ((PagingVO)data).getRecords();
            this.translate(list);
        } else {
            this.translate(data);
        }
        return twOutput;
    }

    private Object translate(Object result) {
        Object obj;
        boolean collectionFlag = result instanceof List;
        if (collectionFlag) {
            List olist = (List)result;
            if (olist.size() == 0) {
                return result;
            }
            obj = olist.get(0);
        } else {
            obj = result;
        }
        if (null != obj) {
            List<UdcDTO> udcParams = this.getUdcMapping(obj, obj.getClass(), null, null);
            if (udcParams.size() == 0) {
                return result;
            }
            if (collectionFlag) {
                for (Object entity : (List)result) {
                    this.assign(entity, udcParams);
                }
            } else {
                this.assign(result, udcParams);
            }
        }
        return result;
    }

    public void assign(Object entity, List<UdcDTO> dictParams) {
        List listTypeUdc = dictParams.stream().filter(udcDTO -> StringUtils.hasText((String)udcDTO.getType()) && udcDTO.getType().equals(COLLECTION_FIELD_TYPE)).collect(Collectors.toList());
        List listFieldKeys = listTypeUdc.stream().map(UdcDTO::getListFieldName).distinct().collect(Collectors.toList());
        for (String listFieldKey : listFieldKeys) {
            try {
                Class<?> c = entity.getClass();
                if (c == null) continue;
                Field f = c.getDeclaredField(listFieldKey);
                f.setAccessible(true);
                Object preValue = f.get(entity);
                if (!ObjectUtil.isNotNull((Object)preValue)) continue;
                Collection list = (Collection)preValue;
                for (Object obj : list) {
                    for (UdcDTO dictParam : listTypeUdc) {
                        this.translation(obj, dictParam);
                    }
                }
                f.set(entity, list);
            }
            catch (Exception e) {
                log.error("[UDC\u7ffb\u8bd1\u5f02\u5e38]:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        List generalTypeUdc = dictParams.stream().filter(udcDTO -> !StringUtils.hasText((String)udcDTO.getType()) || !StringUtils.hasText((String)udcDTO.getListFieldName())).collect(Collectors.toList());
        for (UdcDTO dictParam : generalTypeUdc) {
            this.translation(entity, dictParam);
        }
    }

    private void translation(Object entity, UdcDTO dictParam) {
        String selectionKey = dictParam.getUdcName();
        String codePropName = dictParam.getCodePropName();
        String filedName = dictParam.getFieldName();
        try {
            Class<?> c = entity.getClass();
            if (c != null) {
                Field f = c.getDeclaredField(codePropName);
                f.setAccessible(true);
                Object preValue = f.get(entity);
                if (ObjectUtil.isNotNull((Object)preValue)) {
                    Field fValue = c.getDeclaredField(filedName);
                    fValue.setAccessible(true);
                    if (selectionKey.equals(UdcTypeEnum.USER.getCode())) {
                        fValue.set(entity, this.cacheUtil.getUserName(Long.valueOf(preValue.toString())));
                    } else if (selectionKey.equals(UdcTypeEnum.BU.getCode())) {
                        fValue.set(entity, this.cacheUtil.getOrgName(Long.valueOf(preValue.toString())));
                    } else {
                        fValue.set(entity, this.cacheUtil.transferSystemSelection(selectionKey, preValue.toString()));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("[UDC\u7ffb\u8bd1\u5f02\u5e38]:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private List<UdcDTO> getUdcMapping(Object entity, Class cla, String listFieldName, String fieldType) {
        Field[] fields = cla.getDeclaredFields();
        ArrayList<UdcDTO> list = new ArrayList<UdcDTO>();
        for (Field field : fields) {
            Class<?> type = field.getType();
            if (Collection.class.isAssignableFrom(type)) {
                String name = field.getName();
                try {
                    List olist;
                    Field f = cla.getDeclaredField(name);
                    f.setAccessible(true);
                    Object obj = f.get(entity);
                    if (null != obj && obj instanceof List && (olist = (List)obj).size() > 0) {
                        obj = olist.get(0);
                        Class<?> aClass = obj.getClass();
                        list.addAll(this.getUdcMapping(obj, aClass, name, COLLECTION_FIELD_TYPE));
                    }
                }
                catch (Exception e) {
                    log.error("UDC \u7ffb\u8bd1\u5f02\u5e38-\u5b50\u96c6\u5408\uff1a{}", (Object)e.getMessage(), (Object)e);
                }
            }
            if (!field.isAnnotationPresent(UdcName.class)) continue;
            UdcName udcName = field.getAnnotation(UdcName.class);
            UdcDTO udcDto = new UdcDTO(udcName.udcName(), udcName.codePropName(), field.getName());
            udcDto.setListFieldName(listFieldName);
            udcDto.setType(fieldType);
            list.add(udcDto);
        }
        return list;
    }
}

