package com.elitesland.tw.tw5.server.common.funConfig.controller;

import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessTablePayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessTableQuery;
import com.elitesland.tw.tw5.api.common.funConfig.query.TableQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableFieldsService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableVO;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.TableInfo;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 业务对象表
 *
 * @author duwh
 * @folder 页面配置
 * @date 2023-06-14
 */
@Api(tags = "业务对象表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/common/funConfig/businessTable")
@Slf4j
public class BusinessTableController {

    private final BusinessTableService businessTableService;
    private final BusinessTableFieldsService businessTableFieldsService;
    @Value("${tw.generator.enabled:false}")
    private Boolean generatorEnabled;

    /**
     * 业务对象表-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @PostMapping
    @ApiOperation("业务对象表-新增")
    public TwOutputUtil<BusinessTableVO> insert(@RequestBody BusinessTablePayload payload) {
        return TwOutputUtil.ok(businessTableService.insert(payload));
    }

    /**
     * 业务对象表-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @PutMapping
    @ApiOperation("业务对象表-更新")
    public TwOutputUtil<BusinessTableVO> update(@RequestBody BusinessTablePayload payload) {
        return TwOutputUtil.ok(businessTableService.update(payload));
    }

    /**
     * 业务对象表-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @PutMapping("update")
    @ApiOperation("业务对象表-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessTablePayload payload) {
        return TwOutputUtil.ok(businessTableService.updateByKeyDynamic(payload));
    }

    /**
     * 业务对象表-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("业务对象表-主键查询")
    public TwOutputUtil<BusinessTableVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessTableService.queryByKey(key));
    }

    /**
     * 业务对象表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @GetMapping("/paging")
//     @UdcNameClass
    @ApiOperation("业务对象表-分页")
    public TwOutputUtil<PagingVO<BusinessTableVO>> paging(BusinessTableQuery query) {
        return TwOutputUtil.ok(businessTableService.queryPaging(query));
    }

    /**
     * //TODO 后续删除 读取数据库表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @GetMapping("/tables")
    @ApiOperation("读取数据库表-分页")
    public TwOutputUtil<PagingVO<TableInfo>> tables(TableQuery query) {
        return TwOutputUtil.ok(businessTableService.tables(query));
    }

    @ApiOperation("同步字段数据")
    @PostMapping(value = "sync")
    public TwOutputUtil syncColumn(@RequestBody List<Long> tableIdList) {
        businessTableFieldsService.syncColumn(tableIdList);
        return TwOutputUtil.ok();
    }

    /**
     * 业务对象表-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("业务对象表-查询列表")
    public TwOutputUtil<List<BusinessTableVO>> queryList(BusinessTableQuery query) {
        return TwOutputUtil.ok(businessTableService.queryListDynamic(query));
    }

    @GetMapping("/listAll")
    // @UdcNameClass
    @ApiOperation("业务对象表-查询列表+字段集合")
    public TwOutputUtil<List<BusinessTableVO>> listAll(BusinessTableQuery query) {
        return TwOutputUtil.ok(businessTableService.listAll(query));
    }

    /**
     * 业务对象表-删除
     *
     * @param keys 主键id
     * @return result
     * @folder 页面配置
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("业务对象表-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        businessTableService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @ApiOperation("生成代码")
    @PostMapping(value = "generatorCode/{type}")
    public TwOutputUtil generatorCode(@PathVariable Integer type, Long id, String projectModule,
                                      String apiGorupName,
                                      String packageName,
                                      String author,
                                      String moduleName,
                                      String prefix,
                                      boolean cover) {
        if (!generatorEnabled && type == 0) {
            return TwOutputUtil.error("此环境不允许生成代码，请选择预览或者下载查看！");
        }
        switch (type) {
            // 生成代码
            case 0:
                businessTableService.generator(id, projectModule, apiGorupName, packageName, author, moduleName, prefix, cover);
                break;
//            // 预览
//            case 1: return businessTableService.preview(genConfigService.find(tableName), generatorService.getColumns(tableName));
//            // 打包
//            case 2: businessTableService.download(genConfigService.find(tableName), generatorService.getColumns(tableName), request, response);
//                break;
            default:
                return TwOutputUtil.error("没有这个选项");
        }
        return TwOutputUtil.ok();
    }

}

