package com.elitesland.tw.tw5.server.common.funConfig.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableVO;
import com.elitesland.tw.tw5.server.common.TwAssert;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessTableDAO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessTableFieldsRepo;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessTableFieldsDAO;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessTableFieldsConvert;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableFieldsService;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessTableFieldsPayload;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessTableFieldsDO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableFieldsVO;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessTableFieldsQuery;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessTableFieldsConvert;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 业务对象字段明细
 *
 * @author duwh
 * @date 2023-06-14
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessTableFieldsServiceImpl extends BaseServiceImpl implements BusinessTableFieldsService {

    private final BusinessTableFieldsRepo businessTableFieldsRepo;
    private final BusinessTableFieldsDAO businessTableFieldsDAO;
    @Resource
    private BusinessTableDAO businessTableDAO;
    @PersistenceContext
    private EntityManager em;

    @Override
    public PagingVO<BusinessTableFieldsVO> queryPaging(BusinessTableFieldsQuery query) {
        return businessTableFieldsDAO.queryPaging(query);
    }


    /**
     * 查询数据库的表字段数据数据
     *
     * @param tableName 表名
     * @return {@link List}<{@link BusinessTableFieldsVO}>
     */
    @Override
    public List<BusinessTableFieldsVO> query(String tableName) {
        // 使用预编译防止sql注入
        String sql = "select column_name, is_nullable, data_type, column_comment, column_key, extra,column_default,column_type  from information_schema.columns " +
            "where table_name = ? and table_schema = (select database()) order by ordinal_position";
        Query query = em.createNativeQuery(sql);
        query.setParameter(1, tableName);
        List result = query.getResultList();
        List<BusinessTableFieldsVO> columnInfos = new ArrayList<>();
        for (Object obj : result) {
            Object[] arr = (Object[]) obj;
            columnInfos.add(
                new BusinessTableFieldsVO(
                    tableName,
                    arr[0].toString(),
                    "NO".equals(arr[1]),
                    arr[2].toString(),
                    ObjectUtil.isNotNull(arr[3]) ? arr[3].toString() : null,
                    ObjectUtil.isNotNull(arr[4]) ? arr[4].toString() : null,
                    ObjectUtil.isNotNull(arr[5]) ? arr[5].toString() : null,
                    ObjectUtil.isNotNull(arr[6]) ? arr[6].toString() : null
                )
            );
        }

//        columnInfos.forEach(businessTableFieldsVO -> businessTableFieldsVO.setTableId(tableId));
        // 过滤无用字段
        columnInfos = getColumnInfos(columnInfos);
        return columnInfos;
    }

    @Override
    public List<BusinessTableFieldsVO> queryListDynamic(BusinessTableFieldsQuery query) {
        Long tableId = query.getTableId();
        if (tableId == null) {
            throw TwException.error("", "tableId不能为空");
        }
        List<BusinessTableFieldsVO> businessTableFieldsVOS = businessTableFieldsDAO.queryListDynamic(query);
        if (CollectionUtil.isNotEmpty(businessTableFieldsVOS)) {
//            businessTableFieldsVOS = getColumnInfos(businessTableFieldsVOS);
            return businessTableFieldsVOS;
        } else {
            BusinessTableVO businessTableVO = businessTableDAO.queryByKey(tableId);
            Assert.notNull(businessTableVO, "不存在");
            businessTableFieldsVOS = query(businessTableVO.getTableName());
            businessTableFieldsVOS.forEach(businessTableFieldsVO -> businessTableFieldsVO.setTableId(tableId));
//            businessTableFieldsVOS = getColumnInfos(businessTableFieldsVOS);
            List<BusinessTableFieldsDO> businessTableFieldsDOS = BusinessTableFieldsConvert.INSTANCE.voToDoList(businessTableFieldsVOS);
            List<BusinessTableFieldsDO> doList = businessTableFieldsRepo.saveAll(businessTableFieldsDOS);
            return BusinessTableFieldsConvert.INSTANCE.toVoList(doList);
        }
    }

    public List<BusinessTableFieldsVO> queryList(BusinessTableFieldsQuery query) {
        Long tableId = query.getTableId();
        if (tableId == null) {
            throw TwException.error("", "tableId不能为空");
        }
        List<BusinessTableFieldsVO> businessTableFieldsVOS = businessTableFieldsDAO.queryListDynamic(query);
        return businessTableFieldsVOS;
    }


    private List<BusinessTableFieldsVO> getColumnInfos(List<BusinessTableFieldsVO> columnInfos) {
        columnInfos = columnInfos.stream().filter(columnInfo -> !(
            columnInfo.getField().equals("tenant_id")
                //|| columnInfo.getColumnName().equals("id")
//                || columnInfo.getField().equals("remark")
//                || columnInfo.getField().equals("create_user_id")
//                || columnInfo.getField().equals("creator")
//                || columnInfo.getField().equals("create_time")
//                || columnInfo.getField().equals("modify_user_id")
//                || columnInfo.getField().equals("updater")
//                || columnInfo.getField().equals("modify_time")
                || columnInfo.getField().equals("delete_flag")
                || columnInfo.getField().equals("audit_data_version")
                || columnInfo.getField().equals("sec_bu_id")
                || columnInfo.getField().equals("sec_user_id")
                || columnInfo.getField().equals("tenant_org_id")
                || columnInfo.getField().equals("belong_org_id")
                || columnInfo.getField().equals("sec_ou_id"))
        ).collect(Collectors.toList());
        return columnInfos;
    }

    @Override
    public BusinessTableFieldsVO queryByKey(Long key) {
        BusinessTableFieldsDO entity = businessTableFieldsRepo.findById(key).orElseGet(BusinessTableFieldsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessTableFieldsVO vo = BusinessTableFieldsConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessTableFieldsVO insert(BusinessTableFieldsPayload payload) {
        BusinessTableFieldsDO entityDo = BusinessTableFieldsConvert.INSTANCE.toDo(payload);
        return BusinessTableFieldsConvert.INSTANCE.toVo(businessTableFieldsRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessTableFieldsVO update(BusinessTableFieldsPayload payload) {
        BusinessTableFieldsDO entity = businessTableFieldsRepo.findById(payload.getId()).orElseGet(BusinessTableFieldsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessTableFieldsDO entityDo = BusinessTableFieldsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessTableFieldsConvert.INSTANCE.toVo(businessTableFieldsRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessTableFieldsPayload payload) {
        BusinessTableFieldsDO entity = businessTableFieldsRepo.findById(payload.getId()).orElseGet(BusinessTableFieldsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessTableFieldsDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<BusinessTableFieldsDO> optional = businessTableFieldsRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessTableFieldsDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    businessTableFieldsRepo.save(entity);
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void syncColumn(List<Long> tableIdList) {
        for (Long tableId : tableIdList) {
            BusinessTableVO businessTableVO = businessTableDAO.queryByKey(tableId);
            Assert.notNull(businessTableVO, "不存在");
            BusinessTableFieldsQuery query = new BusinessTableFieldsQuery();
            query.setTableId(tableId);
            List<BusinessTableFieldsVO> oldList = queryList(query);

            List<BusinessTableFieldsVO> newList = query(businessTableVO.getTableName());

            // 第一种情况，数据库类字段改变或者新增字段
            for (BusinessTableFieldsVO columnInfo : newList) {
                // 根据字段名称查找
                List<BusinessTableFieldsVO> columns = oldList.stream().filter(c -> c.getField().equals(columnInfo.getField())).collect(Collectors.toList());
                // 如果能找到，就修改部分可能被字段
                if (CollectionUtil.isNotEmpty(columns)) {
                    BusinessTableFieldsVO column = columns.get(0);
                    column.setType(columnInfo.getType());
                    column.setExt1(columnInfo.getExt1());
                    column.setExt2(columnInfo.getExt2());
                    if (StringUtils.isBlank(column.getRemark())) {
                        column.setRemark(columnInfo.getRemark());
                    }
                    BusinessTableFieldsPayload businessTableFieldsPayload = BusinessTableFieldsConvert.INSTANCE.toPayload(column);
                    businessTableFieldsDAO.updateByKeyDynamic(businessTableFieldsPayload);
                } else {
                    columnInfo.setTableId(tableId);
                    BusinessTableFieldsPayload businessTableFieldsPayload = BusinessTableFieldsConvert.INSTANCE.toPayload(columnInfo);
                    // 如果找不到，则保存新字段信息
                    insert(businessTableFieldsPayload);
                }
            }
            // 第二种情况，数据库字段删除了
//            for (BusinessTableFieldsVO columnInfo : oldList) {
//                // 根据字段名称查找
//                List<BusinessTableFieldsVO> columns = newList.stream().filter(c -> c.getField().equals(columnInfo.getField())).collect(Collectors.toList());
//                // 如果找不到，就代表字段被删除了，则需要删除该字段
//                if (CollectionUtil.isEmpty(columns)) {
//                    deleteSoft(Arrays.asList(columnInfo.getId()));
//                }
//            }

        }
    }

}
