package com.elitesland.tw.tw5.server.common.util;

import org.springframework.boot.web.servlet.filter.OrderedRequestContextFilter;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;

/**
 * @author neo.pan
 * @since 2018/06/29
 */
public abstract class EdpWebUtil {

    /**
     * 应用服务根路径(PC)
     */
    public static final String APP_API = "/api";

    /**
     * 应用服务根路径(移动端)
     */
    public static final String MOB_API = "/mob";

    /**
     * EDP服务根路径
     */
    public static final String EDS_API = "/eds";

    public static final String EDS_API_V2 = "/eds/v2";

    /**
     * 面向开发或演示用API根路径
     */
    public static final String DEV_API = "/dev";

    /**
     * 用户身份认证API根路径(PC端)
     */
    public static final String SEC_PC = "/sec/pc";

    /**
     * 用户身份认证API根路径(移动端端)
     */
    public static final String SEC_MOB = "/sec/mob";

    /**
     * 大于 <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/MAX_SAFE_INTEGER>{@code Number.MAX_SAFE_INTEGER}</a> 的整数在JS中会丢失精度
     */
    public static final long JS_MAX_SAFE_NUMBER = ((long) Math.pow(2, 53)) - 1;
    /**
     * 小于 <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/MIN_SAFE_INTEGER>{@code Number.MIN_SAFE_INTEGER}</a> 的整数在JS中会丢失精度
     */
    public static final long JS_MIN_SAFE_NUMBER = -JS_MAX_SAFE_NUMBER;

    /**
     * 媒体类型：JSON
     */
    public static final String MEDIA_JSON = "application/json; charset=UTF-8";
    /**
     * 媒体类型：XML
     */
    public static final String MEDIA_XML = "application/xml; charset=UTF-8";

    /**
     * @return 生成安全随机数(对于JS来说)
     */
    public static long generateSafeNumber() {
        return ThreadLocalRandom.current().nextLong(0L, JS_MAX_SAFE_NUMBER);
    }

    /**
     * @return 当前HTTP请求
     */
    public static Optional<HttpServletRequest> getRequest() {
        return getRequestContext().map(ServletRequestAttributes::getRequest);
    }

    /**
     * {@link RequestContextHolder}的数据来源于{@link OrderedRequestContextFilter}。
     * 如果不是在HTTP请求上下文（比如系统定时任务）中使用该方法则返回为空。
     *
     * @return 当前HTTP请求上下文
     */
    public static Optional<ServletRequestAttributes> getRequestContext() {
        return Optional.ofNullable((ServletRequestAttributes) RequestContextHolder.getRequestAttributes());
    }

}
