package com.elitesland.tw.tw5.server.prd.org.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgOrganizationPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgOrganizationRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgRolePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.org.entity.*;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgEmployeeRefRepo;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgOrganizationRefRepo;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgOrganizationRepo;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgRoleRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Repository
@RequiredArgsConstructor
public class PrdOrgOrganizationDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdOrgOrganizationRepo repo;
    private final PrdOrgOrganizationRefRepo refRepo;
    private final PrdOrgEmployeeRefRepo employeeRefRepo;
    private final PrdOrgRoleRepo roleRepo;
    private final QPrdOrgOrganizationDO qdo = new QPrdOrgOrganizationDO("prdOrgOrganizationDO");
    private final QPrdOrgOrganizationDO o_qdo = new QPrdOrgOrganizationDO("prdOrgOrganizationDO1");
    private final QPrdOrgOrganizationRefDO qdoRef = QPrdOrgOrganizationRefDO.prdOrgOrganizationRefDO;
    private final QPrdOrgEmployeeDO qdoEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QPrdOrgEmployeeRefDO qdoEmployeeRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdOrgRoleDO qdoRole = QPrdOrgRoleDO.prdOrgRoleDO;
    private final QPrdOrgDimensionDO qdoDim = QPrdOrgDimensionDO.prdOrgDimensionDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgOrganizationVO> getJpaQuerySelect() {
        JPAQuery<PrdOrgOrganizationVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdOrgOrganizationVO.class,
                qdo.id,
                qdo.orgName,
                qdo.orgCode,
                qdo.extString1,
                qdo.extString2,
                qdo.extString3,
                qdo.extString4,
                qdo.extString5,
                qdo.extString6,
                qdo.extString7,
                qdo.extString8,
                qdo.extString9,
                qdo.extString10,
                qdo.manageId,
                qdoEmployee.employeeName.as("manageName"),
                qdoRef.parentId,
                o_qdo.orgName.as("parentName"),
                qdoDim.dimensionName,
                qdo.isBu,
                qdo.orgStatus

        )).from(qdo).leftJoin(qdoRef).on(qdo.id.longValue().eq(qdoRef.orgId.longValue()))
                .leftJoin(o_qdo).on(o_qdo.id.longValue().eq(qdoRef.parentId.longValue()))
                .leftJoin(qdoEmployee).on(qdo.manageId.longValue().eq(qdoEmployee.userId.longValue()))
                .leftJoin(qdoDim).on(qdo.dimensionId.longValue().eq(qdoDim.id.longValue()));
        return jpaQuery;
    }

    /**
     * 拼装查询条件
     * .
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgOrganizationVO> getJpaQueryWhere(PrdOrgOrganizationQuery query) {
        JPAQuery<PrdOrgOrganizationVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdoRef.orgType.eq(1));
        if (!ObjectUtils.isEmpty(query.getDimensionId())) {
            jpaQuery.where(qdo.dimensionId.eq(query.getDimensionId()));
        }
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            jpaQuery.where(qdoRef.parentId.eq(query.getParentId()));
        }
        if (!ObjectUtils.isEmpty(query.getOrgName())) {
            jpaQuery.where(qdo.orgName.like(SqlUtil.toSqlLikeString(query.getOrgName())));
        }
        if (!ObjectUtils.isEmpty(query.getOrgCode())) {
            jpaQuery.where(qdo.orgCode.eq(query.getOrgCode()));
        }
        if (!ObjectUtils.isEmpty(query.getManageId())) {
            jpaQuery.where(qdo.manageId.eq(query.getManageId()));
        }
        if (!ObjectUtils.isEmpty(query.getOrgStatus())) {
            jpaQuery.where(qdo.orgStatus.eq(query.getOrgStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getIsBu())) {
            jpaQuery.where(qdo.isBu.eq(query.getIsBu()));
        }
        jpaQuery.where(qdoDim.versionId.eq(0L));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoRef, SqlUtil.getOrderse()));
        jpaQuery.groupBy(qdo.id);
        return jpaQuery;
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdOrgOrganizationVO> queryPaging(PrdOrgOrganizationQuery query) {
        JPAQuery<PrdOrgOrganizationVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<PrdOrgOrganizationVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PrdOrgOrganizationVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgRoleVO> getJpaQueryRoleSelect() {
        JPAQuery<PrdOrgRoleVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdOrgRoleVO.class,
                qdoRole.id,
                qdoRole.orgId,
                qdoRole.roleName,
                qdoRole.roleCode,
                qdoRole.roleEmployees,
                qdoRole.extString1,
                qdoRole.extString2,
                qdoRole.extString3,
                qdoRole.extString4,
                qdoRole.extString5,
                qdoRole.extString6,
                qdoRole.extString7,
                qdoRole.extString8,
                qdoRole.extString9,
                qdoRole.extString10,
                qdoRole.remark
        )).from(qdoRole);
        return jpaQuery;
    }

    /**
     * 根据组织id查询角色数据
     *
     * @param orgId
     * @return 结果
     */
    public List<PrdOrgRoleVO> queryRoleList(Long orgId) {
        JPAQuery<PrdOrgRoleVO> jpaQuery = getJpaQueryRoleSelect();
        if (orgId != null) {
            jpaQuery.where(qdoRole.orgId.eq(orgId));
        }
        jpaQuery.where(qdoRole.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgOrganizationVO> getJpaQueryOrgSelect() {
        JPAQuery<PrdOrgOrganizationVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdOrgOrganizationVO.class,
                qdo.id,
                qdo.orgName,
                qdo.orgCode,
                qdo.extString1,
                qdo.extString2,
                qdo.extString3,
                qdo.extString4,
                qdo.extString5,
                qdo.extString6,
                qdo.extString7,
                qdo.extString8,
                qdo.extString9,
                qdo.extString10,
                qdo.manageId,
                qdoEmployee.employeeName.as("manageName"),
                qdo.isBu,
                qdo.orgStatus

        )).from(qdo).leftJoin(qdoEmployee).on(qdo.manageId.longValue().eq(qdoEmployee.userId.longValue()).and(qdoEmployee.deleteFlag.eq(0)));
        return jpaQuery;
    }

    /**
     * 根据组织id查询员工数据
     *
     * @param orgId
     * @return 结果
     */
    public PrdOrgOrganizationVO queryOrgById(Long orgId) {
        JPAQuery<PrdOrgOrganizationVO> jpaQuery = getJpaQueryOrgSelect();
        jpaQuery.where(qdo.id.eq(orgId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgOrganizationVO> getJpaQueryOrgDataSelect() {
        JPAQuery<PrdOrgOrganizationVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdOrgOrganizationVO.class,
                qdo.id,
                qdo.orgName,
                qdo.orgCode,
                qdo.orgStatus

        )).from(qdo).leftJoin(qdoRef).on(qdo.id.longValue().eq(qdoRef.parentId.longValue()));
        return jpaQuery;
    }

    /**
     * 查询上级组织
     *
     * @param orgId
     * @return 结果
     */
    public PrdOrgOrganizationVO queryParentOrgById(Long orgId) {
        JPAQuery<PrdOrgOrganizationVO> jpaQuery = getJpaQueryOrgDataSelect();
        jpaQuery.where(qdoRef.orgId.eq(orgId));
        jpaQuery.where(qdoRef.orgType.eq(1));
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据员工id查询员工数据
     *
     * @param keys
     * @return 结果
     */
    public List<PrdOrgEmployeeRefVO> queryRoleEmployeeList(List<Long> keys) {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeRefVO.class,
                qdoEmployee.employeeName,
                qdoEmployee.userId
        )).from(qdoEmployee);
        jpaQuery.where(qdoEmployee.userId.in(keys));
        jpaQuery.where(qdoEmployee.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeRefVO> getJpaQueryEmployeeRefSelect() {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeRefVO.class,
                qdoEmployeeRef.id,
                qdoEmployee.employeeName,
                qdoEmployee.employeeNo,
                qdoEmployee.id.as("employeeId"),
                qdoEmployeeRef.orgId,
                qdoEmployeeRef.userId,
                qdoEmployeeRef.sortIndex,
                qdoEmployeeRef.parentId

        )).from(qdoEmployee).leftJoin(qdoEmployeeRef).on(qdoEmployee.userId.longValue().eq(qdoEmployeeRef.userId.longValue()));
        return jpaQuery;
    }

    /**
     * 根据组织id查询员工数据
     *
     * @param orgId
     * @return 结果
     */
    public List<PrdOrgEmployeeRefVO> queryEmployeeList(Long orgId) {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = getJpaQueryEmployeeRefSelect();
        jpaQuery.where(qdoEmployeeRef.orgId.eq(orgId));
        jpaQuery.where(qdoEmployeeRef.deleteFlag.eq(0));

        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoEmployeeRef, SqlUtil.getOrderse()));
        return jpaQuery.fetch();
    }

    /**
     * 根据组织id查询员工数据
     *
     * @param orgIds
     * @return 结果
     */
    public List<PrdOrgEmployeeRefVO> queryEmployeeList(Set<Long> orgIds) {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = getJpaQueryEmployeeRefSelect();
        jpaQuery.where(qdoEmployeeRef.orgId.in(orgIds));
        jpaQuery.where(qdoEmployeeRef.deleteFlag.eq(0));
        jpaQuery.where(qdoEmployee.resourceStatus.ne(String.valueOf(6)));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoEmployeeRef, SqlUtil.getOrderse()));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgOrganizationRefVO> getJpaQueryOrgRefSelect() {
        JPAQuery<PrdOrgOrganizationRefVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdOrgOrganizationRefVO.class,
                qdoRef.id,
                qdo.dimensionId,
                qdo.orgName,
                qdo.orgCode,
                qdo.manageId,
                qdoRef.sortIndex,
                qdoRef.orgId,
                qdoRef.parentId,
                qdoRef.orgType,
                qdo.orgStatus
        )).from(qdo).leftJoin(qdoRef).on(qdo.id.longValue().eq(qdoRef.orgId.longValue())).leftJoin(qdoDim).on(qdoDim.id.longValue().eq(qdoRef.dimensionId.longValue()));
        return jpaQuery;
    }

    /**
     * 根据维度id查询
     *
     * @param dimensionId 维度
     * @param orgStatus   组织状态
     * @return 结果
     */
    public List<PrdOrgOrganizationRefVO> queryOrgList(Long dimensionId, String orgStatus) {
        JPAQuery<PrdOrgOrganizationRefVO> jpaQuery = getJpaQueryOrgRefSelect();
        if (dimensionId != null) {
            //如果是-1认为能查询所有的维度
            if (dimensionId > -1L) {
                jpaQuery.where(qdoDim.id.eq(dimensionId));
            } else {
                jpaQuery.where(qdoDim.versionId.eq(0L));
            }
        } else {
            jpaQuery.where(qdoDim.defaultFlag.eq(0).and(qdoDim.versionId.eq(0L)));
        }
        jpaQuery.where(qdoDim.deleteFlag.eq(0));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        if (StringUtils.hasText(orgStatus)) {
            jpaQuery.where(qdo.orgStatus.eq(orgStatus));
        }
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoRef, SqlUtil.getOrderse()));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgOrganizationRefVO> getJpaQueryAllOrgRefSelect() {
        JPAQuery<PrdOrgOrganizationRefVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdOrgOrganizationRefVO.class,
                qdo.id.as("orgId"),
                qdo.orgName,
                qdo.dimensionId,
                qdoRef.parentId,
                qdo.orgStatus,
                qdoDim.dimensionName
        )).from(qdo)
                .leftJoin(qdoDim).on(qdo.dimensionId.longValue().eq(qdoDim.id.longValue()))
                .leftJoin(qdoRef).on(qdo.id.longValue().eq(qdoRef.orgId.longValue()));
        return jpaQuery;
    }

    /**
     * 查询所有
     * dimensionId
     *
     * @return 结果
     */
    public List<PrdOrgOrganizationRefVO> queryAll(String code, Long dimensionId, Boolean defaultFlag) {
        JPAQuery<PrdOrgOrganizationRefVO> jpaQuery = getJpaQueryAllOrgRefSelect();
        jpaQuery.where(qdoDim.versionId.eq(0L));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdoDim.deleteFlag.eq(0));
        jpaQuery.where(qdo.orgStatus.eq(SystemDefaultEnum.DefaultOrgStatus.getCode()));
        if (code != null && !code.equals("")) {
            jpaQuery.where(qdo.orgCode.eq(code));
        }
        if (dimensionId != null) {
            jpaQuery.where(qdo.dimensionId.ne(dimensionId));
        } else {
            jpaQuery.where(qdoDim.defaultFlag.eq(0));
        }
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        jpaQuery.where(qdoRef.orgType.eq(1));
//        if (defaultFlag != null && defaultFlag) {
//            jpaQuery.where(qdoDim.defaultFlag.eq(0));
//        }
//        else{
//            jpaQuery.where(qdoDim.defaultFlag.ne(0));
//        }
        return jpaQuery.fetch();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdOrgOrganizationDO save(PrdOrgOrganizationDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存
     *
     * @param employeeRefDOs do对象
     * @return 保存后的对象
     */
    public List<PrdOrgEmployeeRefDO> saveEmployeeRef(List<PrdOrgEmployeeRefDO> employeeRefDOs) {
        return employeeRefRepo.saveAll(employeeRefDOs);
    }

    /**
     * 删除组织员工关系
     *
     * @param userIds 员工id
     * @return 删除的行数
     */
    public long updateEmployeeRefFlag(List<Long> userIds) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoEmployeeRef)
                .set(qdoEmployeeRef.deleteFlag, 1)
                .set(qdoEmployeeRef.leaveDate, LocalDate.now())
                .where(qdoEmployeeRef.userId.in(userIds))
                .where(qdoEmployeeRef.isCopy.eq(0));
        return update.execute();
    }

    /**
     * 更新默认状态
     *
     * @param userIds 员工id
     * @return 删除的行数
     */
    public long updateEmployeeRefStatus(List<Long> userIds) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoEmployeeRef)
                .set(qdoEmployeeRef.isDefault, 1)
                .where(qdoEmployeeRef.userId.in(userIds))
                .where(qdoEmployeeRef.isCopy.eq(0));
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @return 删除的行数
     */
    public long deleteEmployeeRefSoft(Long orgId, List<Long> userIds) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoEmployeeRef)
                .set(qdoEmployeeRef.deleteFlag, 1)
                .set(qdoEmployeeRef.leaveDate, LocalDate.now())
                .where(qdoEmployeeRef.orgId.eq(orgId))
                .where(qdoEmployeeRef.isDefault.eq(1))
                .where(qdoEmployeeRef.userId.in(userIds));
        return update.execute();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado doref对象
     * @return 保存后的对象
     */
    public PrdOrgOrganizationRefDO saveRef(PrdOrgOrganizationRefDO ado) {
        return refRepo.save(ado);
    }


    /**
     * 根据主键查询
     *
     * @param id
     * @return 结果
     */
    public PrdOrgOrganizationRefVO queryByRefId(Long id) {
        JPAQuery<PrdOrgOrganizationRefVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdOrgOrganizationRefVO.class,
                qdo.id,
                qdo.dimensionId
        )).from(qdo);
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 查询组织关系
     *
     * @param dimensionId orgId
     * @return 结果
     */
    public PrdOrgOrganizationRefDO queryByDimensionIdOrOrgId(Long dimensionId, Long orgId) {
        JPAQuery<PrdOrgOrganizationRefDO> jpaQuery = jpaQueryFactory.select(qdoRef).from(qdoRef);
        jpaQuery.where(qdoRef.dimensionId.eq(dimensionId));
        jpaQuery.where(qdoRef.orgId.eq(orgId));
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 查询组织负责人所有的组织
     *
     * @param manageId
     * @return 结果
     */
    public List<Long> queryByManageIdOrgIds(Long manageId) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.id).from(qdo);
        jpaQuery.where(qdo.manageId.eq(manageId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 更新关系的父级组织
     *
     * @param
     * @return 修改的行数
     */
    public long updateRef(PrdOrgOrganizationRefPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoRef)
                .where(qdoRef.dimensionId.longValue().eq(payload.getDimensionId().longValue())).where(qdoRef.orgId.eq(payload.getOrgId())).set(qdoRef.parentId, payload.getParentId());

        // 执行修改
        return update.execute();
    }

    /**
     * 按主键动态修改
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PrdOrgOrganizationPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

//        if (payload.getOrgStatus() != null) {
//            update.set(qdo.orgStatus, payload.getOrgStatus());
//        }
        if (payload.getOrgName() != null) {
            update.set(qdo.orgName, payload.getOrgName());
        }
        if (payload.getOrgCode() != null) {
            update.set(qdo.orgCode, payload.getOrgCode());
        }
        if (payload.getManageId() != null) {
            update.set(qdo.manageId, payload.getManageId());
        }
//        if (payload.getSortIndex() != null) {
//            update.set(qdo.sortIndex, payload.getSortIndex());
//        }
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        if (payload.getExtString1() != null) {
            update.set(qdo.extString1, payload.getExtString1());
        }
        if (payload.getExtString2() != null) {
            update.set(qdo.extString2, payload.getExtString2());
        }
        if (payload.getExtString3() != null) {
            update.set(qdo.extString3, payload.getExtString3());
        }
        if (payload.getExtString4() != null) {
            update.set(qdo.extString4, payload.getExtString4());
        }
        if (payload.getExtString5() != null) {
            update.set(qdo.extString5, payload.getExtString5());
        }
        if (payload.getExtString6() != null) {
            update.set(qdo.extString6, payload.getExtString6());
        }
        if (payload.getExtString7() != null) {
            update.set(qdo.extString7, payload.getExtString7());
        }
        if (payload.getExtString8() != null) {
            update.set(qdo.extString8, payload.getExtString8());
        }
        if (payload.getExtString9() != null) {
            update.set(qdo.extString9, payload.getExtString9());
        }
        if (payload.getExtString10() != null) {
            update.set(qdo.extString10, payload.getExtString10());
        }
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("remark")) {
                update.setNull(qdo.remark);
            }
        }
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param key 主键
     * @return 删除的行数
     */
    public long deleteSoft(Long key) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.eq(key));
        return update.execute();
    }

    /**
     * 逻辑删除关系表
     *
     * @param key 主键
     * @return 删除的行数
     */
    public long deleteRefSoft(Long key) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoRef)
                .set(qdoRef.deleteFlag, 1)
                .where(qdoRef.id.eq(key));
        return update.execute();
    }

    /**
     * 逻辑删除所有关系表
     *
     * @param orgId
     * @return 删除的行数
     */
    public long deleteAllRefSoft(Long orgId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoRef)
                .set(qdoRef.deleteFlag, 1)
                .where(qdoRef.orgId.eq(orgId));
        return update.execute();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdOrgRoleDO saveRole(PrdOrgRoleDO ado) {
        return roleRepo.save(ado);
    }

    /**
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateRole(PrdOrgRolePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoRole)
                .where(qdoRole.id.eq(payload.getId()));
        if (payload.getRoleName() != null) {
            update.set(qdoRole.roleName, payload.getRoleName());
        }
        if (payload.getRoleCode() != null) {
            update.set(qdoRole.roleCode, payload.getRoleCode());
        }
        if (payload.getRoleEmployees() != null) {
            update.set(qdoRole.roleEmployees, payload.getRoleEmployees());
        }
        if (payload.getRemark() != null) {
            update.set(qdoRole.remark, payload.getRemark());
        }
        if (payload.getExtString1() != null) {
            update.set(qdoRole.extString1, payload.getExtString1());
        }
        if (payload.getExtString2() != null) {
            update.set(qdoRole.extString2, payload.getExtString2());
        }
        if (payload.getExtString3() != null) {
            update.set(qdoRole.extString3, payload.getExtString3());
        }
        if (payload.getExtString4() != null) {
            update.set(qdoRole.extString4, payload.getExtString4());
        }
        if (payload.getExtString5() != null) {
            update.set(qdo.extString5, payload.getExtString5());
        }
        if (payload.getExtString6() != null) {
            update.set(qdoRole.extString6, payload.getExtString6());
        }
        if (payload.getExtString7() != null) {
            update.set(qdoRole.extString7, payload.getExtString7());
        }
        if (payload.getExtString8() != null) {
            update.set(qdo.extString8, payload.getExtString8());
        }
        if (payload.getExtString9() != null) {
            update.set(qdoRole.extString9, payload.getExtString9());
        }
        if (payload.getExtString10() != null) {
            update.set(qdoRole.extString10, payload.getExtString10());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("remark")) {
                update.setNull(qdoRole.remark);
            }
        }
        return update.execute();
    }

    /**
     * 根据父id查询组织
     *
     * @param parentId
     * @return 结果
     */
    public PrdOrgOrganizationRefDO queryFirstByParentId(Long parentId) {
        JPAQuery<PrdOrgOrganizationRefDO> jpaQuery = jpaQueryFactory.select(qdoRef).from(qdoRef);
        jpaQuery.where(qdoRef.parentId.eq(parentId));
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 查询子组织
     *
     * @param parentId
     * @return
     */
    public List<PrdOrgOrganizationRefDO> queryAllByParentId(Long parentId) {
        JPAQuery<PrdOrgOrganizationRefDO> jpaQuery = jpaQueryFactory.select(qdoRef).from(qdoRef);
        jpaQuery.where(qdoRef.parentId.eq(parentId));
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 查询组织
     *
     * @param orgId
     * @return 结果
     */
    public PrdOrgOrganizationDO queryById(Long orgId) {
        JPAQuery<PrdOrgOrganizationDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.id.eq(orgId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据组织编码查组织
     */
    public PrdOrgOrganizationDO queryByOrgCode(String orgCode) {
        JPAQuery<PrdOrgOrganizationDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.orgCode.eq(orgCode));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    public List<PrdOrgOrganizationDO> queryByOrgCode(List<String> orgCodes) {
        JPAQuery<PrdOrgOrganizationDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.orgCode.in(orgCodes));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 查询组织
     *
     * @param orgName
     * @return 结果
     */
    public PrdOrgOrganizationDO queryByName(String orgName) {
        JPAQuery<PrdOrgOrganizationDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.orgName.eq(orgName));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据负责人查其负责的组织集合
     * 负责组织
     *
     * @param manageId
     * @return 结果
     */
    public List<PrdOrgOrganizationDO> queryByManagerId(Long manageId) {
        JPAQuery<PrdOrgOrganizationDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.manageId.eq(manageId));
        jpaQuery.where(qdo.orgStatus.eq(SystemDefaultEnum.DefaultOrgStatus.getCode()));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }


    /**
     * 查询所有的子部门
     *
     * @param orgIdList
     */
    public Set<Long> queryAllChildOrgs(Set<Long> orgIdList) {
        Set<Long> childOrgs = repo.queryChildOrgs(orgIdList);
        if (!CollectionUtils.isEmpty(childOrgs)) {
            Set<Long> childOrgs1 = queryAllChildOrgs(childOrgs);
            childOrgs.addAll(childOrgs1);
        }
        return childOrgs;
    }


    /**
     * 修改默认角色负责人
     *
     * @param orgId 组织id roleCode,组织编号
     * @return 删除的行数
     */
    public long updateRoleEmployees(Long orgId, String roleCode, String roleEmployees) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoRole)
                .set(qdoRole.roleEmployees, roleEmployees)
                .where(qdoRole.orgId.eq(orgId))
                .where(qdoRole.roleCode.eq(roleCode));
        return update.execute();
    }

    /**
     * 逻辑删除角色表
     *
     * @param key 主键
     * @return 删除的行数
     */
    public long deleteRoleSoft(Long key) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoRole)
                .set(qdoRole.deleteFlag, 1)
                .where(qdoRole.id.eq(key));
        return update.execute();
    }

    /**
     * 更新状态
     *
     * @param
     * @return 修改的行数
     */
    public long updateStatus(Long id, String orgStatus) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(id)).set(qdo.orgStatus, orgStatus);
        return update.execute();
    }

    /**
     * 查询组织角色
     *
     * @param key
     * @return 结果
     */
    public PrdOrgRoleDO queryRoleByKey(Long key) {
        JPAQuery<PrdOrgRoleDO> jpaQuery = jpaQueryFactory.select(qdoRole).from(qdoRole);
        jpaQuery.where(qdoRole.id.eq(key));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据主键id查询组织关系
     *
     * @param ids
     * @return 结果
     */
    public List<PrdOrgOrganizationRefDO> queryByOrgRefIds(List<Long> ids) {
        JPAQuery<PrdOrgOrganizationRefDO> jpaQuery = jpaQueryFactory.select(qdoRef).from(qdoRef);
        jpaQuery.where(qdoRef.id.in(ids));
        return jpaQuery.fetch();
    }

    /**
     * 根据主键id查询组织关系
     *
     * @param ids
     * @return 结果
     */
    public List<PrdOrgEmployeeRefDO> queryByEmployeeRefIds(List<Long> ids) {
        JPAQuery<PrdOrgEmployeeRefDO> jpaQuery = jpaQueryFactory.select(qdoEmployeeRef).from(qdoEmployeeRef);
        jpaQuery.where(qdoEmployeeRef.id.in(ids));
        return jpaQuery.fetch();
    }

    /**
     * 根据组织id和用户Id查询组织关系
     *
     * @return 结果
     */
    public PrdOrgEmployeeRefDO queryByOrgIdAndEmpId(Long orgId, Long userId) {
        JPAQuery<PrdOrgEmployeeRefDO> jpaQuery = jpaQueryFactory.select(qdoEmployeeRef).from(qdoEmployeeRef);
        jpaQuery.where(qdoEmployeeRef.orgId.eq(orgId));
        jpaQuery.where(qdoEmployeeRef.userId.eq(userId));
        jpaQuery.where(qdoEmployeeRef.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 更新关系的父级组织
     *
     * @param
     * @return 修改的行数
     */
    public long updateOrgRef(PrdOrgOrganizationRefDO payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoRef)
                .where(qdoRef.id.longValue().eq(payload.getId().longValue()));
        if (payload.getParentId() != null) {
            update.set(qdoRef.parentId, payload.getParentId());
        }
        if (payload.getSortIndex() != null) {
            update.set(qdoRef.sortIndex, payload.getSortIndex());
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 更新关系的父级组织
     *
     * @param
     * @return 修改的行数
     */
    public long updateEmployeeRef(PrdOrgEmployeeRefDO payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoEmployeeRef)
                .where(qdoEmployeeRef.id.longValue().eq(payload.getId().longValue()));
        if (payload.getOrgId() != null) {
            update.set(qdoEmployeeRef.orgId, payload.getOrgId());
        }
        if (payload.getSortIndex() != null) {
            update.set(qdoEmployeeRef.sortIndex, payload.getSortIndex());
        }
        // 执行修改
        return update.execute();
    }

    public Long queryManageIdByCode(String code) {
        PrdOrgOrganizationDO prdOrgOrganizationDO = repo.queryByOrgCodeAndDeleteFlagAndIsCopy(code, 0, 0).orElse(null);
        if (prdOrgOrganizationDO != null) {
            return prdOrgOrganizationDO.getManageId();
        }
        return null;
    }

    public Long queryManageIdById(Long id) {
        PrdOrgOrganizationDO prdOrgOrganizationDO = repo.queryByIdAndDeleteFlagAndIsCopy(id, 0, 0).orElse(null);
        if (prdOrgOrganizationDO != null) {
            return prdOrgOrganizationDO.getManageId();
        }
        return null;
    }


    /**
     * 查询个人组织
     *
     * @return 结果
     */
    public List<Long> queryOrgIdSByKey(Long userId) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoEmployeeRef.orgId).from(qdoEmployeeRef).leftJoin(qdo).on(qdo.id.longValue().eq(qdoEmployeeRef.orgId.longValue()));
        jpaQuery.where(qdoEmployeeRef.userId.eq(userId));
        jpaQuery.where(qdoEmployeeRef.deleteFlag.eq(0));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdoEmployeeRef.isCopy.eq(0));
        return jpaQuery.fetch();
    }

    public Long getOrgIdByV4(Long orgIdV4) {
        return repo.getOrgIdByV4(orgIdV4);
    }

    public List<Map<String, Object>> queryOrgs(List<Long> orgIds) {
        return repo.queryOrgs(orgIds);
    }

    public List<Map<String, Object>> getV4AndV5OrgIds() {
        return repo.getV4AndV5OrgIds();
    }


}
