package com.elitesland.tw.tw5.server.prd.sms.service;

import cn.hutool.core.lang.Validator;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.coord.messenger.sender.provider.SmsRpcService;
import com.elitescloud.coord.messenger.sender.provider.param.SimpleSmsDTO;
import com.elitescloud.coord.messenger.sender.provider.param.TemplateSmsDTO;
import com.elitesland.tw.tw5.server.prd.sms.config.TwSmsProperties;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * tw短信服务封装
 *
 * @author duwh
 * @date 2023/06/08
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TwSmsServiceImpl implements TwSmsService {

    private final SmsRpcService smsRpcService;
    private final TwSmsProperties twSmsProperties;

    @Override
    public ApiResult<Boolean> sendTemplateMsg(String phone, String templateCode, Map map) {
        if (!twSmsProperties.getEnabled()) {
            return ApiResult.fail("短信服务未启用");
        }
        //取出手机号后校验
        boolean isMobile = Validator.isMobile(phone);
        if (!isMobile) {
            log.error("短信发送异常，手机号格式错误：【{}】", phone);
            return ApiResult.fail("手机号格式错误");
        }
        TemplateSmsDTO smsDTO = new TemplateSmsDTO();
        Set<String> mobile = new HashSet<>();
        mobile.add(phone);

        String smsTemplateCode = templateCode;
        smsDTO.setTemplateCode(smsTemplateCode);
        smsDTO.setSignName("埃林哲CRM");
        smsDTO.setMobiles(mobile);

        smsDTO.setSubject("Elitesland");
        smsDTO.setBusinessType("CRM-TESTSEND");

        map.put("templateCode", smsTemplateCode);
        smsDTO.setTemplateParams(map);
        return sendTemplateMsg(smsDTO);
    }

    /**
     * 发送模板短信
     *
     * @param smsDTO 短信参数
     * @return 发送结果
     */
    @Override
    public ApiResult<Boolean> sendTemplateMsg(TemplateSmsDTO smsDTO) {
        if (!twSmsProperties.getEnabled()) {
            return ApiResult.fail("短信服务未启用");
        }
        return smsRpcService.sendTemplateMsg(smsDTO);
    }

    /**
     * 发送普通短信
     *
     * @param smsDTO 短信参数
     * @return 发送结果
     */
    @Override
    public ApiResult<Boolean> sendSimpleMsg(SimpleSmsDTO smsDTO) {
        if (!twSmsProperties.getEnabled()) {
            return ApiResult.fail("短信服务未启用");
        }
        return smsRpcService.sendSimpleMsg(smsDTO);
    }
}
